/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModWidget
extends BrowserWidget
implements ModifyListener {
    private Schema schema;
    private Shell shell;
    private Composite modComposite;
    private ArrayList<ModSpec> modSpecList;
    private String ldif;

    public ModWidget(Schema schema) {
        this.schema = schema;
        this.modSpecList = new ArrayList();
        this.ldif = null;
    }

    public void dispose() {
    }

    public String getLdif() {
        return this.ldif;
    }

    public Composite createContents(Composite parent) {
        this.shell = parent.getShell();
        this.modComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        this.addModSpec(this.modComposite, 0);
        return this.modComposite;
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    public void validate() {
        for (int i = 0; i < this.modSpecList.size(); ++i) {
            ModSpec modSpec = this.modSpecList.get(i);
            if (this.modSpecList.size() > 1) {
                modSpec.modDeleteButton.setEnabled(true);
            } else {
                modSpec.modDeleteButton.setEnabled(false);
            }
            for (int k = 0; k < modSpec.valueLineList.size(); ++k) {
                ValueLine valueLine = (ValueLine)modSpec.valueLineList.get(k);
                if (modSpec.valueLineList.size() > 1) {
                    valueLine.valueDeleteButton.setEnabled(true);
                    continue;
                }
                valueLine.valueDeleteButton.setEnabled(false);
            }
        }
        this.notifyListeners();
    }

    private void addModSpec(Composite modComposite, int index) {
        ModSpec[] modSpecs = this.modSpecList.toArray(new ModSpec[this.modSpecList.size()]);
        if (modSpecs.length > 0) {
            for (int i = 0; i < modSpecs.length; ++i) {
                ModSpec oldModSpec = modSpecs[i];
                String oldType = oldModSpec.modType.getText();
                String oldAttribute = oldModSpec.modAttributeCombo.getText();
                String[] oldValues = new String[oldModSpec.valueLineList.size()];
                for (int k = 0; k < oldValues.length; ++k) {
                    oldValues[k] = ((ValueLine)oldModSpec.valueLineList.get(k)).valueText.getText();
                }
                oldModSpec.modGroup.dispose();
                oldModSpec.modAddButton.dispose();
                oldModSpec.modDeleteButton.dispose();
                this.modSpecList.remove(oldModSpec);
                ModSpec newModSpec = this.createModSpec(modComposite);
                this.modSpecList.add(newModSpec);
                newModSpec.modType.setText(oldType);
                newModSpec.modAttributeCombo.setText(oldAttribute);
                this.deleteValueLine(newModSpec, 0);
                for (int k = 0; k < oldValues.length; ++k) {
                    this.addValueLine(newModSpec, k);
                    ValueLine newValueLine = (ValueLine)newModSpec.valueLineList.get(k);
                    newValueLine.valueText.setText(oldValues[k]);
                }
                if (index != i + 1) continue;
                ModSpec modSpec = this.createModSpec(modComposite);
                this.modSpecList.add(modSpec);
            }
        } else {
            ModSpec modSpec = this.createModSpec(modComposite);
            this.modSpecList.add(modSpec);
        }
        this.shell.layout(true, true);
    }

    private ModSpec createModSpec(final Composite modComposite) {
        ModSpec modSpec = new ModSpec();
        modSpec.modGroup = BaseWidgetUtils.createGroup((Composite)modComposite, (String)"", (int)1);
        Composite modSpecComposite = BaseWidgetUtils.createColumnContainer((Composite)modSpec.modGroup, (int)2, (int)1);
        modSpec.modType = BaseWidgetUtils.createCombo((Composite)modSpecComposite, (String[])new String[]{"add", "replace", "delete"}, (int)0, (int)1);
        modSpec.modType.addModifyListener((ModifyListener)this);
        Object[] attributeDescriptions = SchemaUtils.getNamesAsArray((Collection)this.schema.getAttributeTypeDescriptions());
        Arrays.sort(attributeDescriptions);
        modSpec.modAttributeCombo = BaseWidgetUtils.createCombo((Composite)modSpecComposite, (String[])new String[0], (int)-1, (int)1);
        new ExtendedContentAssistCommandAdapter((Control)modSpec.modAttributeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider((String[])attributeDescriptions), null, null, true);
        modSpec.modAddButton = new Button(modComposite, 8);
        modSpec.modAddButton.setText("  +   ");
        modSpec.modAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ModWidget.this.modSpecList.size();
                for (int i = 0; i < ModWidget.this.modSpecList.size(); ++i) {
                    ModSpec modSpec = (ModSpec)ModWidget.this.modSpecList.get(i);
                    if (modSpec.modAddButton != e.widget) continue;
                    index = i + 1;
                }
                ModWidget.this.addModSpec(modComposite, index);
                ModWidget.this.validate();
            }
        });
        modSpec.modDeleteButton = new Button(modComposite, 8);
        modSpec.modDeleteButton.setText("  \u2212  ");
        modSpec.modDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                for (int i = 0; i < ModWidget.this.modSpecList.size(); ++i) {
                    ModSpec modSpec = (ModSpec)ModWidget.this.modSpecList.get(i);
                    if (modSpec.modDeleteButton != e.widget) continue;
                    index = i;
                }
                ModWidget.this.deleteModSpec(modComposite, index);
                ModWidget.this.validate();
            }
        });
        this.addValueLine(modSpec, 0);
        return modSpec;
    }

    private void deleteModSpec(Composite modComposite, int index) {
        ModSpec modSpec = this.modSpecList.remove(index);
        if (modSpec != null) {
            modSpec.modGroup.dispose();
            modSpec.modAddButton.dispose();
            modSpec.modDeleteButton.dispose();
            if (!modComposite.isDisposed()) {
                this.shell.layout(true, true);
            }
        }
    }

    private void addValueLine(ModSpec modSpec, int index) {
        ValueLine[] valueLines = modSpec.valueLineList.toArray(new ValueLine[modSpec.valueLineList.size()]);
        if (valueLines.length > 0) {
            for (int i = 0; i < valueLines.length; ++i) {
                ValueLine oldValueLine = valueLines[i];
                String oldValue = oldValueLine.valueText.getText();
                oldValueLine.valueComposite.dispose();
                modSpec.valueLineList.remove(oldValueLine);
                ValueLine newValueLine = this.createValueLine(modSpec);
                modSpec.valueLineList.add(newValueLine);
                newValueLine.valueText.setText(oldValue);
                if (index != i + 1) continue;
                ValueLine valueLine = this.createValueLine(modSpec);
                modSpec.valueLineList.add(valueLine);
            }
        } else {
            ValueLine valueLine = this.createValueLine(modSpec);
            modSpec.valueLineList.add(valueLine);
        }
        this.shell.layout(true, true);
    }

    private ValueLine createValueLine(final ModSpec modSpec) {
        ValueLine valueLine = new ValueLine();
        valueLine.valueComposite = BaseWidgetUtils.createColumnContainer((Composite)modSpec.modGroup, (int)3, (int)1);
        valueLine.valueText = BaseWidgetUtils.createText((Composite)valueLine.valueComposite, (String)"", (int)1);
        valueLine.valueText.addModifyListener((ModifyListener)this);
        valueLine.valueAddButton = new Button(valueLine.valueComposite, 8);
        valueLine.valueAddButton.setText("  +   ");
        valueLine.valueAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = modSpec.valueLineList.size();
                for (int i = 0; i < modSpec.valueLineList.size(); ++i) {
                    ValueLine valueLine = (ValueLine)modSpec.valueLineList.get(i);
                    if (valueLine.valueAddButton != e.widget) continue;
                    index = i + 1;
                }
                ModWidget.this.addValueLine(modSpec, index);
                ModWidget.this.validate();
            }
        });
        valueLine.valueDeleteButton = new Button(valueLine.valueComposite, 8);
        valueLine.valueDeleteButton.setText("  \u2212  ");
        valueLine.valueDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                for (int i = 0; i < modSpec.valueLineList.size(); ++i) {
                    ValueLine valueLine = (ValueLine)modSpec.valueLineList.get(i);
                    if (valueLine.valueDeleteButton != e.widget) continue;
                    index = i;
                }
                ModWidget.this.deleteValueLine(modSpec, index);
                ModWidget.this.validate();
            }
        });
        return valueLine;
    }

    private void deleteValueLine(ModSpec modSpec, int index) {
        ValueLine valueLine = (ValueLine)modSpec.valueLineList.remove(index);
        if (valueLine != null) {
            valueLine.valueComposite.dispose();
            if (!this.modComposite.isDisposed()) {
                this.shell.layout(true, true);
            }
        }
    }

    public String getLdifFragment() {
        StringBuffer sb = new StringBuffer();
        sb.append("changetype: modify").append(BrowserCoreConstants.LINE_SEPARATOR);
        ModSpec[] modSpecs = this.modSpecList.toArray(new ModSpec[this.modSpecList.size()]);
        if (modSpecs.length > 0) {
            for (int i = 0; i < modSpecs.length; ++i) {
                int k;
                ModSpec modSpec = modSpecs[i];
                String type = modSpec.modType.getText();
                String attribute = modSpec.modAttributeCombo.getText();
                String[] values = new String[modSpec.valueLineList.size()];
                for (k = 0; k < values.length; ++k) {
                    values[k] = ((ValueLine)modSpec.valueLineList.get(k)).valueText.getText();
                }
                sb.append(type).append(": ").append(attribute).append(BrowserCoreConstants.LINE_SEPARATOR);
                for (k = 0; k < values.length; ++k) {
                    if (values[k].length() <= 0) continue;
                    sb.append(attribute).append(": ").append(values[k]).append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                sb.append("-").append(BrowserCoreConstants.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    private class ValueLine {
        private Composite valueComposite;
        private Text valueText;
        private Button valueAddButton;
        private Button valueDeleteButton;

        private ValueLine() {
        }
    }

    private class ModSpec {
        private Group modGroup;
        private Combo modType;
        private Combo modAttributeCombo;
        private Button modAddButton;
        private Button modDeleteButton;
        private ArrayList<ValueLine> valueLineList = new ArrayList();

        private ModSpec() {
        }
    }
}

