/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterExtensibleComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterItemComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterContentAssistProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor,
IContentProposalProvider {
    private static final Comparator<String> nameAndOidComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1.matches("[0-9\\.]+") && !s2.matches("[0-9\\.]+")) {
                return 1;
            }
            if (!s1.matches("[0-9\\.]+") && s2.matches("[0-9\\.]+")) {
                return -1;
            }
            return s1.compareToIgnoreCase(s2);
        }
    };
    private LdapFilterParser parser;
    private ISourceViewer sourceViewer;
    private char[] autoActivationCharacters;
    private Schema schema;
    private Map<String, AttributeTypeDescription> possibleAttributeTypes;
    private Map<String, String> possibleFilterTypes;
    private Map<String, ObjectClassDescription> possibleObjectClasses;
    private Map<String, MatchingRuleDescription> possibleMatchingRules;

    public FilterContentAssistProcessor(LdapFilterParser parser) {
        this(null, parser);
    }

    public FilterContentAssistProcessor(ISourceViewer sourceViewer, LdapFilterParser parser) {
        this.parser = parser;
        this.sourceViewer = sourceViewer;
        this.autoActivationCharacters = new char[69];
        this.autoActivationCharacters[0] = 40;
        this.autoActivationCharacters[1] = 41;
        this.autoActivationCharacters[2] = 38;
        this.autoActivationCharacters[3] = 124;
        this.autoActivationCharacters[4] = 33;
        this.autoActivationCharacters[5] = 58;
        this.autoActivationCharacters[6] = 46;
        int i = 7;
        int c = 97;
        while (c <= 122) {
            this.autoActivationCharacters[i] = c;
            c = (char)(c + 1);
            ++i;
        }
        c = 65;
        while (c <= 90) {
            this.autoActivationCharacters[i] = c;
            c = (char)(c + 1);
            ++i;
        }
        c = 48;
        while (c <= 57) {
            this.autoActivationCharacters[i] = c;
            c = (char)(c + 1);
            ++i;
        }
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
        this.possibleAttributeTypes = new TreeMap<String, AttributeTypeDescription>(nameAndOidComparator);
        this.possibleFilterTypes = new LinkedHashMap<String, String>();
        this.possibleObjectClasses = new TreeMap<String, ObjectClassDescription>(nameAndOidComparator);
        this.possibleMatchingRules = new TreeMap<String, MatchingRuleDescription>(nameAndOidComparator);
        if (schema != null) {
            Collection attributeTypeDescriptions = schema.getAttributeTypeDescriptions();
            for (AttributeTypeDescription atd : attributeTypeDescriptions) {
                this.possibleAttributeTypes.put(atd.getNumericOid(), atd);
                for (String atdName : atd.getNames()) {
                    this.possibleAttributeTypes.put(atdName, atd);
                }
            }
            this.possibleFilterTypes.put("=", Messages.getString("FilterContentAssistProcessor.Equals"));
            this.possibleFilterTypes.put("=*", Messages.getString("FilterContentAssistProcessor.Present"));
            this.possibleFilterTypes.put("<=", Messages.getString("FilterContentAssistProcessor.LessThanOrEquals"));
            this.possibleFilterTypes.put(">=", Messages.getString("FilterContentAssistProcessor.GreaterThanOrEquals"));
            this.possibleFilterTypes.put("~=", Messages.getString("FilterContentAssistProcessor.Approximately"));
            Collection ocds = schema.getObjectClassDescriptions();
            for (ObjectClassDescription ocd : ocds) {
                this.possibleObjectClasses.put(ocd.getNumericOid(), ocd);
                for (String name : ocd.getNames()) {
                    this.possibleObjectClasses.put(name, ocd);
                }
            }
            Collection matchingRuleDescriptions = schema.getMatchingRuleDescriptions();
            for (MatchingRuleDescription description : matchingRuleDescriptions) {
                this.possibleMatchingRules.put(description.getNumericOid(), description);
                for (String name : description.getNames()) {
                    this.possibleMatchingRules.put(name, description);
                }
            }
        }
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationCharacters;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposals(offset);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        this.parser.parse(contents);
        ICompletionProposal[] oldProposals = this.computeCompletionProposals(position);
        IContentProposal[] proposals = new IContentProposal[oldProposals.length];
        for (int i = 0; i < oldProposals.length; ++i) {
            final ICompletionProposal oldProposal = oldProposals[i];
            final Document document = new Document(contents);
            oldProposal.apply((IDocument)document);
            proposals[i] = new IContentProposal(){

                public String getContent() {
                    return document.get();
                }

                public int getCursorPosition() {
                    return oldProposal.getSelection((IDocument)document).x;
                }

                public String getDescription() {
                    return oldProposal.getAdditionalProposalInfo();
                }

                public String getLabel() {
                    return oldProposal.getDisplayString();
                }

                public String toString() {
                    return this.getContent();
                }
            };
        }
        return proposals;
    }

    private ICompletionProposal[] computeCompletionProposals(int offset) {
        Object[] possibleObjectClasses = this.schema == null ? new String[]{} : SchemaUtils.getNamesAsArray((Collection)this.schema.getObjectClassDescriptions());
        Arrays.sort(possibleObjectClasses);
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>();
        LdapFilter filter = this.parser.getModel().getFilter(offset);
        if (filter != null && offset > 0) {
            LdapFilterItemComponent fc;
            if (filter.getStartToken() != null && filter.getFilterComponent() == null) {
                ICompletionProposal[] templateProposals;
                if (this.sourceViewer != null && (templateProposals = super.computeCompletionProposals((ITextViewer)this.sourceViewer, offset)) != null) {
                    proposalList.addAll(Arrays.asList(templateProposals));
                }
                this.addPossibleAttributeTypes(proposalList, "", offset);
            }
            if (filter.getFilterComponent() != null && filter.getFilterComponent() instanceof LdapFilterItemComponent) {
                fc = (LdapFilterItemComponent)filter.getFilterComponent();
                if (fc.getStartToken().getOffset() <= offset && offset <= fc.getStartToken().getOffset() + fc.getStartToken().getLength()) {
                    this.addPossibleAttributeTypes(proposalList, fc.getAttributeToken().getValue(), fc.getAttributeToken().getOffset());
                }
                String attributeType = null;
                if (this.schema != null && this.schema.hasAttributeTypeDescription(fc.getAttributeToken().getValue())) {
                    attributeType = fc.getAttributeToken().getValue();
                }
                if (attributeType != null && (fc.getAttributeToken().getOffset() <= offset || fc.getFilterToken() != null) && offset <= fc.getAttributeToken().getOffset() + fc.getAttributeToken().getLength() + (fc.getFilterToken() != null ? fc.getFilterToken().getLength() : 0)) {
                    String filterType = fc.getFilterToken() != null ? fc.getFilterToken().getValue() : "";
                    int filterTypeOffset = fc.getAttributeToken().getOffset() + fc.getAttributeToken().getLength();
                    this.addPossibleFilterTypes(proposalList, attributeType, filterType, filterTypeOffset);
                }
                if (attributeType != null && "objectClass".equalsIgnoreCase(attributeType) && (fc.getValueToken() != null && fc.getValueToken().getOffset() <= offset || fc.getFilterToken() != null) && offset <= fc.getAttributeToken().getOffset() + fc.getAttributeToken().getLength() + (fc.getFilterToken() != null ? fc.getFilterToken().getLength() : 0) + (fc.getValueToken() != null ? fc.getValueToken().getLength() : 0)) {
                    this.addPossibleObjectClasses(proposalList, fc.getValueToken() == null ? "" : fc.getValueToken().getValue(), fc.getValueToken() == null ? offset : fc.getValueToken().getOffset());
                }
            }
            if (filter.getFilterComponent() != null && filter.getFilterComponent() instanceof LdapFilterExtensibleComponent) {
                fc = (LdapFilterExtensibleComponent)filter.getFilterComponent();
                if (fc.getAttributeToken() != null && fc.getAttributeToken().getOffset() <= offset && offset <= fc.getAttributeToken().getOffset() + fc.getAttributeToken().getLength()) {
                    this.addPossibleAttributeTypes(proposalList, fc.getAttributeToken().getValue(), fc.getAttributeToken().getOffset());
                }
                if (fc.getDnAttrToken() != null && fc.getDnAttrToken().getOffset() <= offset && offset <= fc.getDnAttrToken().getOffset() + fc.getDnAttrToken().getLength()) {
                    this.addDnAttr(proposalList, fc.getDnAttrToken().getValue(), fc.getDnAttrToken().getOffset());
                }
                if (fc.getMatchingRuleColonToken() != null && fc.getMatchingRuleToken() == null && fc.getMatchingRuleColonToken().getOffset() <= offset && offset <= fc.getMatchingRuleColonToken().getOffset() + fc.getMatchingRuleColonToken().getLength()) {
                    if (fc.getDnAttrColonToken() == null) {
                        this.addDnAttr(proposalList, "", offset);
                    }
                    this.addPossibleMatchingRules(proposalList, "", offset, fc.getEqualsColonToken(), fc.getEqualsToken());
                }
                if (fc.getMatchingRuleToken() != null && fc.getMatchingRuleToken().getOffset() <= offset && offset <= fc.getMatchingRuleToken().getOffset() + fc.getMatchingRuleToken().getLength()) {
                    if (fc.getDnAttrColonToken() == null) {
                        this.addDnAttr(proposalList, fc.getMatchingRuleToken().getValue(), fc.getMatchingRuleToken().getOffset());
                    }
                    String matchingRuleValue = fc.getMatchingRuleToken().getValue();
                    this.addPossibleMatchingRules(proposalList, matchingRuleValue, fc.getMatchingRuleToken().getOffset(), fc.getEqualsColonToken(), fc.getEqualsToken());
                }
            }
        }
        return proposalList.toArray(new ICompletionProposal[0]);
    }

    private void addPossibleAttributeTypes(List<ICompletionProposal> proposalList, String attributeType, int offset) {
        if (this.schema != null) {
            for (String possibleAttributeType : this.possibleAttributeTypes.keySet()) {
                AttributeTypeDescription description = this.possibleAttributeTypes.get(possibleAttributeType);
                if (!possibleAttributeType.toUpperCase().startsWith(attributeType.toUpperCase())) continue;
                String replacementString = possibleAttributeType;
                String displayString = possibleAttributeType;
                displayString = displayString.equals(description.getNumericOid()) ? displayString + " (" + SchemaUtils.toString((AbstractSchemaDescription)description) + ")" : displayString + " (" + description.getNumericOid() + ")";
                String info = SchemaUtils.getLdifLine((AbstractSchemaDescription)description);
                CompletionProposal proposal = new CompletionProposal(replacementString, offset, attributeType.length(), replacementString.length(), this.getAttributeTypeImage(), displayString, null, info);
                proposalList.add((ICompletionProposal)proposal);
            }
        }
    }

    private void addPossibleFilterTypes(List<ICompletionProposal> proposalList, String attributeType, String filterType, int offset) {
        if (this.schema != null) {
            LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>(this.possibleFilterTypes);
            if (SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)this.schema.getAttributeTypeDescription(attributeType), (Schema)this.schema) == null) {
                copy.remove("=");
                copy.remove("~=");
            }
            if (SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)this.schema.getAttributeTypeDescription(attributeType), (Schema)this.schema) == null) {
                copy.remove("<=");
                copy.remove(">=");
            }
            Iterator i$ = copy.keySet().iterator();
            while (i$.hasNext()) {
                String possibleFilterType;
                String replacementString = possibleFilterType = (String)i$.next();
                String displayString = (String)copy.get(possibleFilterType);
                CompletionProposal proposal = new CompletionProposal(replacementString, offset, filterType.length(), possibleFilterType.length(), this.getFilterTypeImage(), displayString, null, null);
                proposalList.add((ICompletionProposal)proposal);
            }
        }
    }

    private void addPossibleObjectClasses(List<ICompletionProposal> proposalList, String objectClass, int offset) {
        if (this.schema != null) {
            for (String possibleObjectClass : this.possibleObjectClasses.keySet()) {
                ObjectClassDescription description = this.possibleObjectClasses.get(possibleObjectClass);
                if (!possibleObjectClass.toUpperCase().startsWith(objectClass.toUpperCase())) continue;
                String replacementString = possibleObjectClass;
                String displayString = possibleObjectClass;
                displayString = displayString.equals(description.getNumericOid()) ? displayString + " (" + SchemaUtils.toString((AbstractSchemaDescription)description) + ")" : displayString + " (" + description.getNumericOid() + ")";
                CompletionProposal proposal = new CompletionProposal(replacementString, offset, objectClass.length(), replacementString.length(), this.getObjectClassImage(), displayString, null, SchemaUtils.getLdifLine((AbstractSchemaDescription)this.schema.getObjectClassDescription(possibleObjectClass)));
                proposalList.add((ICompletionProposal)proposal);
            }
        }
    }

    private void addPossibleMatchingRules(List<ICompletionProposal> proposalList, String matchingRule, int offset, LdapFilterToken equalsColonToken, LdapFilterToken equalsToken) {
        if (this.schema != null) {
            for (String possibleMatchingRule : this.possibleMatchingRules.keySet()) {
                String displayString;
                if (!possibleMatchingRule.toUpperCase().startsWith(matchingRule.toUpperCase())) continue;
                MatchingRuleDescription description = this.schema.getMatchingRuleDescription(possibleMatchingRule);
                String replacementString = possibleMatchingRule;
                if (equalsColonToken == null) {
                    replacementString = replacementString + ":";
                }
                if (equalsToken == null) {
                    replacementString = replacementString + "=";
                }
                displayString = (displayString = possibleMatchingRule).equals(description.getNumericOid()) ? displayString + " (" + SchemaUtils.toString((AbstractSchemaDescription)description) + ")" : displayString + " (" + description.getNumericOid() + ")";
                String info = SchemaUtils.getLdifLine((AbstractSchemaDescription)description);
                CompletionProposal proposal = new CompletionProposal(replacementString, offset, matchingRule.length(), replacementString.length(), this.getMatchingRuleImage(), displayString, null, info);
                proposalList.add((ICompletionProposal)proposal);
            }
        }
    }

    private void addDnAttr(List<ICompletionProposal> proposalList, String dnAttr, int offset) {
        if ("dn".toUpperCase().startsWith(dnAttr.toUpperCase())) {
            String replacementString = "dn:";
            String displayString = "dn: ()";
            CompletionProposal proposal = new CompletionProposal(replacementString, offset, dnAttr.length(), replacementString.length(), null, displayString, null, null);
            proposalList.add((ICompletionProposal)proposal);
        }
    }

    private Image getAttributeTypeImage() {
        return BrowserCommonActivator.getDefault().getImage("resources/icons/atd.png");
    }

    private Image getFilterTypeImage() {
        return BrowserCommonActivator.getDefault().getImage("resources/icons/filtereditor.gif");
    }

    private Image getObjectClassImage() {
        return BrowserCommonActivator.getDefault().getImage("resources/icons/ocd.png");
    }

    private Image getMatchingRuleImage() {
        return BrowserCommonActivator.getDefault().getImage("resources/icons/mrd.png");
    }

    protected Template[] getTemplates(String contextTypeId) {
        Template[] templates = BrowserCommonActivator.getDefault().getFilterTemplateStore().getTemplates(BrowserCommonConstants.FILTER_TEMPLATE_ID);
        return templates;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = BrowserCommonActivator.getDefault().getFilterTemplateContextTypeRegistry().getContextType(BrowserCommonConstants.FILTER_TEMPLATE_ID);
        return contextType;
    }

    protected Image getImage(Template template) {
        return BrowserCommonActivator.getDefault().getImage("resources/icons/template.gif");
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

