/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ValuesTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = BrowserCommonConstants.DND_VALUES_TRANSFER;
    private static final int TYPEID = ValuesTransfer.registerType((String)TYPENAME);
    private static ValuesTransfer instance = new ValuesTransfer();

    public static ValuesTransfer getInstance() {
        return instance;
    }

    private ValuesTransfer() {
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof IValue[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            IValue[] values = (IValue[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                for (int i = 0; i < values.length; ++i) {
                    byte[] value;
                    byte[] connectionId = values[i].getAttribute().getEntry().getBrowserConnection().getConnection().getId().getBytes("UTF-8");
                    writeOut.writeInt(connectionId.length);
                    writeOut.write(connectionId);
                    byte[] dn = values[i].getAttribute().getEntry().getDn().getUpName().getBytes("UTF-8");
                    writeOut.writeInt(dn.length);
                    writeOut.write(dn);
                    byte[] attributeName = values[i].getAttribute().getDescription().getBytes("UTF-8");
                    writeOut.writeInt(attributeName.length);
                    writeOut.write(attributeName);
                    if (values[i].isString()) {
                        value = values[i].getStringValue().getBytes("UTF-8");
                        writeOut.writeBoolean(true);
                        writeOut.writeInt(value.length);
                        writeOut.write(value);
                        continue;
                    }
                    if (!values[i].isBinary()) continue;
                    value = values[i].getBinaryValue();
                    writeOut.writeBoolean(false);
                    writeOut.writeInt(value.length);
                    writeOut.write(value);
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        block14: {
            try {
                if (!this.isSupportedType(transferData)) break block14;
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                ArrayList<IValue> valueList = new ArrayList<IValue>();
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    DataInputStream readIn = new DataInputStream(in);
                    do {
                        IBrowserConnection connection = null;
                        if (readIn.available() > 1) {
                            int size = readIn.readInt();
                            byte[] connectionId = new byte[size];
                            readIn.read(connectionId);
                            connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(new String(connectionId, "UTF-8"));
                        }
                        IEntry entry = null;
                        if (readIn.available() <= 1 || connection == null) {
                            return null;
                        }
                        int size = readIn.readInt();
                        byte[] dn = new byte[size];
                        readIn.read(dn);
                        entry = connection.getEntryFromCache(new LdapDN(new String(dn, "UTF-8")));
                        IAttribute attribute = null;
                        if (readIn.available() <= 1 || entry == null) {
                            return null;
                        }
                        int size2 = readIn.readInt();
                        byte[] attributeName = new byte[size2];
                        readIn.read(attributeName);
                        attribute = entry.getAttribute(new String(attributeName, "UTF-8"));
                        IValue value = null;
                        if (readIn.available() > 1 && attribute != null) {
                            boolean isString = readIn.readBoolean();
                            int size3 = readIn.readInt();
                            byte[] val = new byte[size3];
                            readIn.read(val);
                            String test = new String(val, "UTF-8");
                            IValue[] values = attribute.getValues();
                            for (int i = 0; i < values.length; ++i) {
                                if (isString && values[i].isString() && test.equals(values[i].getStringValue())) {
                                    value = values[i];
                                } else {
                                    if (isString || !values[i].isBinary() || !test.equals(new String(values[i].getBinaryValue()))) continue;
                                    value = values[i];
                                }
                                break;
                            }
                        } else {
                            return null;
                        }
                        if (value == null) continue;
                        valueList.add(value);
                    } while (readIn.available() > 1);
                    readIn.close();
                }
                catch (IOException ex) {
                    return null;
                }
                return valueList.isEmpty() ? null : valueList.toArray(new IValue[valueList.size()]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }
}

