/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class EntryTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = BrowserCommonConstants.DND_ENTRY_TRANSFER;
    private static final int TYPEID = EntryTransfer.registerType((String)TYPENAME);
    private static EntryTransfer instance = new EntryTransfer();

    public static EntryTransfer getInstance() {
        return instance;
    }

    private EntryTransfer() {
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof IEntry[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            IEntry[] entries = (IEntry[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                for (int i = 0; i < entries.length; ++i) {
                    byte[] connectionId = entries[i].getBrowserConnection().getConnection().getId().getBytes("UTF-8");
                    writeOut.writeInt(connectionId.length);
                    writeOut.write(connectionId);
                    byte[] dn = entries[i].getDn().getUpName().getBytes("UTF-8");
                    writeOut.writeInt(dn.length);
                    writeOut.write(dn);
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        block8: {
            try {
                if (!this.isSupportedType(transferData)) break block8;
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                ArrayList<IEntry> entryList = new ArrayList<IEntry>();
                try {
                    IBrowserConnection connection = null;
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    DataInputStream readIn = new DataInputStream(in);
                    do {
                        if (readIn.available() > 1) {
                            int size = readIn.readInt();
                            byte[] connectionId = new byte[size];
                            readIn.read(connectionId);
                            connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(new String(connectionId, "UTF-8"));
                        }
                        IEntry entry = null;
                        if (readIn.available() <= 1 || connection == null) {
                            return null;
                        }
                        int size = readIn.readInt();
                        byte[] dn = new byte[size];
                        readIn.read(dn);
                        entry = connection.getEntryFromCache(new LdapDN(new String(dn, "UTF-8")));
                        if (entry == null) continue;
                        entryList.add(entry);
                    } while (readIn.available() > 1);
                    readIn.close();
                }
                catch (IOException ex) {
                    return null;
                }
                return entryList.isEmpty() ? null : entryList.toArray(new IEntry[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }
}

