/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.schema.BinarySyntax;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SyntaxDialog
extends Dialog {
    private BinarySyntax currentSyntax;
    private String[] syntaxOids;
    private BinarySyntax returnSyntax;
    private Combo oidCombo;

    public SyntaxDialog(Shell parentShell, BinarySyntax currentSyntax, String[] syntaxOids) {
        super(parentShell);
        this.currentSyntax = currentSyntax;
        this.syntaxOids = syntaxOids;
        this.returnSyntax = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SyntaxDialog.SelectSyntaxOID"));
    }

    protected void okPressed() {
        this.returnSyntax = new BinarySyntax(this.oidCombo.getText());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite c = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)c, (String)Messages.getString("SyntaxDialog.SyntaxOID"), (int)1);
        this.oidCombo = BaseWidgetUtils.createCombo((Composite)c, (String[])this.syntaxOids, (int)-1, (int)1);
        if (this.currentSyntax != null) {
            this.oidCombo.setText(this.currentSyntax.getSyntaxNumericOid());
        }
        this.oidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SyntaxDialog.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        this.getButton(0).setEnabled(!"".equals(this.oidCombo.getText()));
    }

    public BinarySyntax getSyntax() {
        return this.returnSyntax;
    }
}

