/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EntryEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button autosaveSingleTabButton;
    private Button autosaveMultiTabButton;
    private Button enableFoldingButton;
    private Label foldingThresholdLabel;
    private Text foldingThresholdText;
    private Button autoExpandFoldedAttributesButton;

    public EntryEditorPreferencePage() {
        super(Messages.getString("EntryEditorPreferencePage.EntryEditor"));
        super.setPreferenceStore(BrowserCommonActivator.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("EntryEditorPreferencePage.GeneralSettings"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        String foldingTooltip = Messages.getString("EntryEditorPreferencePage.FoldingToolTip");
        Group foldingGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("EntryEditorPreferencePage.Folding"), (int)1);
        Composite pagingGroupComposite = BaseWidgetUtils.createColumnContainer((Composite)foldingGroup, (int)3, (int)1);
        this.enableFoldingButton = BaseWidgetUtils.createCheckbox((Composite)pagingGroupComposite, (String)Messages.getString("EntryEditorPreferencePage.EnableFolding"), (int)3);
        this.enableFoldingButton.setToolTipText(foldingTooltip);
        this.enableFoldingButton.setSelection(this.getPreferenceStore().getBoolean("entryeditorEnableFolding"));
        this.enableFoldingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryEditorPreferencePage.this.updateEnabled();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)pagingGroupComposite, (int)1);
        this.foldingThresholdLabel = BaseWidgetUtils.createLabel((Composite)pagingGroupComposite, (String)Messages.getString("EntryEditorPreferencePage.FoldingThreshold"), (int)1);
        this.foldingThresholdLabel.setToolTipText(foldingTooltip);
        this.foldingThresholdLabel.setEnabled(this.enableFoldingButton.getSelection());
        this.foldingThresholdText = BaseWidgetUtils.createText((Composite)pagingGroupComposite, (String)this.getPreferenceStore().getString("entryeditorFoldingThreshold"), (int)4, (int)1);
        this.foldingThresholdText.setToolTipText(foldingTooltip);
        this.foldingThresholdText.setEnabled(this.enableFoldingButton.getSelection());
        this.foldingThresholdText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(EntryEditorPreferencePage.this.foldingThresholdText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)pagingGroupComposite, (int)1);
        this.autoExpandFoldedAttributesButton = BaseWidgetUtils.createCheckbox((Composite)pagingGroupComposite, (String)Messages.getString("EntryEditorPreferencePage.AutoExpandFoldedAttributes"), (int)2);
        this.autoExpandFoldedAttributesButton.setEnabled(this.enableFoldingButton.getSelection());
        this.autoExpandFoldedAttributesButton.setSelection(this.getPreferenceStore().getBoolean("entryeditorAutoExpandFoldedAttributes"));
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group autosaveGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("EntryEditorPreferencePage.Autosave"), (int)1);
        Composite autosaveComposite = BaseWidgetUtils.createColumnContainer((Composite)autosaveGroup, (int)1, (int)1);
        this.autosaveSingleTabButton = BaseWidgetUtils.createCheckbox((Composite)autosaveComposite, (String)Messages.getString("EntryEditorPreferencePage.AutosaveSingleTab"), (int)1);
        this.autosaveSingleTabButton.setSelection(this.getPreferenceStore().getBoolean("entryeditorAutoSaveSingleTab"));
        this.autosaveMultiTabButton = BaseWidgetUtils.createCheckbox((Composite)autosaveComposite, (String)Messages.getString("EntryEditorPreferencePage.AutosaveMultiTab"), (int)1);
        this.autosaveMultiTabButton.setSelection(this.getPreferenceStore().getBoolean("entryeditorAutoSaveMultiTab"));
        this.updateEnabled();
        this.applyDialogFont(composite);
        return composite;
    }

    private void updateEnabled() {
        this.foldingThresholdText.setEnabled(this.enableFoldingButton.getSelection());
        this.foldingThresholdLabel.setEnabled(this.enableFoldingButton.getSelection());
        this.autoExpandFoldedAttributesButton.setEnabled(this.enableFoldingButton.getSelection());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("entryeditorAutoSaveSingleTab", this.autosaveSingleTabButton.getSelection());
        this.getPreferenceStore().setValue("entryeditorAutoSaveMultiTab", this.autosaveMultiTabButton.getSelection());
        this.getPreferenceStore().setValue("entryeditorEnableFolding", this.enableFoldingButton.getSelection());
        this.getPreferenceStore().setValue("entryeditorFoldingThreshold", this.foldingThresholdText.getText());
        this.getPreferenceStore().setValue("entryeditorAutoExpandFoldedAttributes", this.autoExpandFoldedAttributesButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        this.autosaveSingleTabButton.setSelection(this.getPreferenceStore().getDefaultBoolean("entryeditorAutoSaveSingleTab"));
        this.autosaveMultiTabButton.setSelection(this.getPreferenceStore().getDefaultBoolean("entryeditorAutoSaveMultiTab"));
        this.enableFoldingButton.setSelection(this.getPreferenceStore().getDefaultBoolean("entryeditorEnableFolding"));
        this.foldingThresholdText.setText(this.getPreferenceStore().getDefaultString("entryeditorFoldingThreshold"));
        this.autoExpandFoldedAttributesButton.setSelection(this.getPreferenceStore().getDefaultBoolean("entryeditorAutoExpandFoldedAttributes"));
        this.updateEnabled();
        super.performDefaults();
    }
}

