/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BrowserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DN = Messages.getString("BrowserPreferencePage.DN");
    private static final String RDN = Messages.getString("BrowserPreferencePage.RDN");
    private static final String RDN_VALUE = Messages.getString("BrowserPreferencePage.RDNValue");
    private Combo entryLabelCombo;
    private Button entryAbbreviateButton;
    private Text entryAbbreviateMaxLengthText;
    private Combo searchResultLabelCombo;
    private Button searchResultAbbreviateButton;
    private Text searchResultAbbreviateMaxLengthText;
    private Button enableFoldingButton;
    private Label foldingSizeLabel;
    private Text foldingSizeText;
    private Button expandBaseEntriesButton;
    private Button checkForChildrenButton;

    public BrowserPreferencePage() {
        super(Messages.getString("BrowserPreferencePage.Browser"));
        super.setPreferenceStore(BrowserCommonActivator.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("BrowserPreferencePage.GeneralSettings"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group entryLabelGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("BrowserPreferencePage.EntryLabel"), (int)1);
        Composite entryLabelComposite = BaseWidgetUtils.createColumnContainer((Composite)entryLabelGroup, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)entryLabelComposite, (String)Messages.getString("BrowserPreferencePage.UseAsEntryLabel1"), (int)1);
        this.entryLabelCombo = BaseWidgetUtils.createCombo((Composite)entryLabelComposite, (String[])new String[]{DN, RDN, RDN_VALUE}, (int)0, (int)1);
        this.entryLabelCombo.setLayoutData((Object)new GridData());
        this.entryLabelCombo.select(this.getPreferenceStore().getInt("browserEntryLabel") == 2 ? 2 : (this.getPreferenceStore().getInt("browserEntryLabel") == 1 ? 1 : 0));
        BaseWidgetUtils.createLabel((Composite)entryLabelComposite, (String)Messages.getString("BrowserPreferencePage.UseAsEntryLabel2"), (int)1);
        Composite entryAbbreviateComposite = BaseWidgetUtils.createColumnContainer((Composite)entryLabelGroup, (int)3, (int)1);
        this.entryAbbreviateButton = BaseWidgetUtils.createCheckbox((Composite)entryAbbreviateComposite, (String)Messages.getString("BrowserPreferencePage.LimitLabelLength1"), (int)1);
        this.entryAbbreviateButton.setSelection(this.getPreferenceStore().getBoolean("browserEntryAbbreviate"));
        this.entryAbbreviateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserPreferencePage.this.updateEnabled();
            }
        });
        this.entryAbbreviateMaxLengthText = BaseWidgetUtils.createText((Composite)entryAbbreviateComposite, (String)this.getPreferenceStore().getString("browserentryAbbreviateMaxLength"), (int)3, (int)1);
        this.entryAbbreviateMaxLengthText.setEnabled(this.entryAbbreviateButton.getSelection());
        this.entryAbbreviateMaxLengthText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(BrowserPreferencePage.this.entryAbbreviateMaxLengthText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        BaseWidgetUtils.createLabel((Composite)entryAbbreviateComposite, (String)Messages.getString("BrowserPreferencePage.LimitLabelLength2"), (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group searchResultLabelGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("BrowserPreferencePage.SearchResultLabel"), (int)1);
        Composite searchResultLabelComposite = BaseWidgetUtils.createColumnContainer((Composite)searchResultLabelGroup, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)searchResultLabelComposite, (String)Messages.getString("BrowserPreferencePage.UseAsSearchResultLabel1"), (int)1);
        this.searchResultLabelCombo = BaseWidgetUtils.createCombo((Composite)searchResultLabelComposite, (String[])new String[]{DN, RDN, RDN_VALUE}, (int)0, (int)1);
        this.searchResultLabelCombo.setLayoutData((Object)new GridData());
        this.searchResultLabelCombo.select(this.getPreferenceStore().getInt("browserSearchResultLabel") == 2 ? 2 : (this.getPreferenceStore().getInt("browserSearchResultLabel") == 1 ? 1 : 0));
        BaseWidgetUtils.createLabel((Composite)searchResultLabelComposite, (String)Messages.getString("BrowserPreferencePage.UseAsSearchResultLabel2"), (int)1);
        Composite searchResultAbbreviateComposite = BaseWidgetUtils.createColumnContainer((Composite)searchResultLabelGroup, (int)3, (int)1);
        this.searchResultAbbreviateButton = BaseWidgetUtils.createCheckbox((Composite)searchResultAbbreviateComposite, (String)Messages.getString("BrowserPreferencePage.LimitLabelLength1"), (int)1);
        this.searchResultAbbreviateButton.setSelection(this.getPreferenceStore().getBoolean("browserWearchResultAbbreviate"));
        this.searchResultAbbreviateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserPreferencePage.this.updateEnabled();
            }
        });
        this.searchResultAbbreviateMaxLengthText = BaseWidgetUtils.createText((Composite)searchResultAbbreviateComposite, (String)this.getPreferenceStore().getString("browserSearchResultAbbreviateMaxLength"), (int)3, (int)1);
        this.searchResultAbbreviateMaxLengthText.setEnabled(this.searchResultAbbreviateButton.getSelection());
        this.searchResultAbbreviateMaxLengthText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(BrowserPreferencePage.this.searchResultAbbreviateMaxLengthText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        BaseWidgetUtils.createLabel((Composite)searchResultAbbreviateComposite, (String)Messages.getString("BrowserPreferencePage.LimitLabelLength2"), (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group foldingGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("BrowserPreferencePage.Folding"), (int)1);
        Composite pagingGroupComposite = BaseWidgetUtils.createColumnContainer((Composite)foldingGroup, (int)2, (int)1);
        this.enableFoldingButton = BaseWidgetUtils.createCheckbox((Composite)pagingGroupComposite, (String)Messages.getString("BrowserPreferencePage.EnableFolding"), (int)2);
        this.enableFoldingButton.setSelection(this.getPreferenceStore().getBoolean("browserEnableFolding"));
        this.enableFoldingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserPreferencePage.this.updateEnabled();
            }
        });
        this.foldingSizeLabel = BaseWidgetUtils.createLabel((Composite)pagingGroupComposite, (String)Messages.getString("BrowserPreferencePage.FoldingSize"), (int)1);
        this.foldingSizeLabel.setEnabled(this.enableFoldingButton.getSelection());
        this.foldingSizeText = BaseWidgetUtils.createText((Composite)pagingGroupComposite, (String)this.getPreferenceStore().getString("browserFoldingSize"), (int)4, (int)1);
        this.foldingSizeText.setEnabled(this.enableFoldingButton.getSelection());
        this.foldingSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(BrowserPreferencePage.this.foldingSizeText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.expandBaseEntriesButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("BrowserPreferencePage.ExpandBaseEntries"), (int)1);
        this.expandBaseEntriesButton.setSelection(this.getPreferenceStore().getBoolean("browserExpandBaseEntries"));
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        this.checkForChildrenButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("BrowserPreferencePage.CheckForChildren"), (int)1);
        this.checkForChildrenButton.setSelection(coreStore.getBoolean("checkForChildren"));
        this.updateEnabled();
        this.applyDialogFont(composite);
        return composite;
    }

    private void updateEnabled() {
        this.entryAbbreviateMaxLengthText.setEnabled(this.entryAbbreviateButton.getSelection());
        this.searchResultAbbreviateMaxLengthText.setEnabled(this.searchResultAbbreviateButton.getSelection());
        this.foldingSizeText.setEnabled(this.enableFoldingButton.getSelection());
        this.foldingSizeLabel.setEnabled(this.enableFoldingButton.getSelection());
    }

    public boolean performOk() {
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        coreStore.setValue("checkForChildren", this.checkForChildrenButton.getSelection());
        BrowserCorePlugin.getDefault().savePluginPreferences();
        this.getPreferenceStore().setValue("browserExpandBaseEntries", this.expandBaseEntriesButton.getSelection());
        this.getPreferenceStore().setValue("browserEnableFolding", this.enableFoldingButton.getSelection());
        this.getPreferenceStore().setValue("browserFoldingSize", this.foldingSizeText.getText().trim());
        this.getPreferenceStore().setValue("browserEntryLabel", this.entryLabelCombo.getSelectionIndex() == 2 ? 2 : (this.entryLabelCombo.getSelectionIndex() == 1 ? 1 : 0));
        this.getPreferenceStore().setValue("browserEntryAbbreviate", this.entryAbbreviateButton.getSelection());
        this.getPreferenceStore().setValue("browserentryAbbreviateMaxLength", this.entryAbbreviateMaxLengthText.getText().trim());
        this.getPreferenceStore().setValue("browserSearchResultLabel", this.searchResultLabelCombo.getSelectionIndex() == 2 ? 2 : (this.searchResultLabelCombo.getSelectionIndex() == 1 ? 1 : 0));
        this.getPreferenceStore().setValue("browserWearchResultAbbreviate", this.searchResultAbbreviateButton.getSelection());
        this.getPreferenceStore().setValue("browserSearchResultAbbreviateMaxLength", this.searchResultAbbreviateMaxLengthText.getText().trim());
        return true;
    }

    protected void performDefaults() {
        this.entryLabelCombo.select(this.getPreferenceStore().getDefaultInt("browserEntryLabel") == 2 ? 2 : (this.getPreferenceStore().getDefaultInt("browserEntryLabel") == 1 ? 1 : 0));
        this.entryAbbreviateButton.setSelection(this.getPreferenceStore().getDefaultBoolean("browserEntryAbbreviate"));
        this.entryAbbreviateMaxLengthText.setText(this.getPreferenceStore().getDefaultString("browserentryAbbreviateMaxLength"));
        this.searchResultLabelCombo.select(this.getPreferenceStore().getDefaultInt("browserSearchResultLabel") == 2 ? 2 : (this.getPreferenceStore().getDefaultInt("browserSearchResultLabel") == 1 ? 1 : 0));
        this.searchResultAbbreviateButton.setSelection(this.getPreferenceStore().getDefaultBoolean("browserWearchResultAbbreviate"));
        this.searchResultAbbreviateMaxLengthText.setText(this.getPreferenceStore().getDefaultString("browserSearchResultAbbreviateMaxLength"));
        this.enableFoldingButton.setSelection(this.getPreferenceStore().getDefaultBoolean("browserEnableFolding"));
        this.foldingSizeText.setText(this.getPreferenceStore().getDefaultString("browserFoldingSize"));
        this.expandBaseEntriesButton.setSelection(this.getPreferenceStore().getDefaultBoolean("browserExpandBaseEntries"));
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        this.checkForChildrenButton.setSelection(coreStore.getDefaultBoolean("checkForChildren"));
        this.updateEnabled();
        super.performDefaults();
    }
}

