/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.schema.BinaryAttribute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AttributeDialog
extends Dialog {
    private BinaryAttribute currentAttribute;
    private String[] attributeTypesAndOids;
    private BinaryAttribute returnAttribute;
    private Combo typeOrOidCombo;

    public AttributeDialog(Shell parentShell, BinaryAttribute currentAttribute, String[] attributeNamesAndOids) {
        super(parentShell);
        this.currentAttribute = currentAttribute;
        this.attributeTypesAndOids = attributeNamesAndOids;
        this.returnAttribute = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AttributeDialog.SelectAttributeTypeOrOID"));
    }

    protected void okPressed() {
        this.returnAttribute = new BinaryAttribute(this.typeOrOidCombo.getText());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite c = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)c, (String)Messages.getString("AttributeDialog.AttributeTypeOrOID"), (int)1);
        this.typeOrOidCombo = BaseWidgetUtils.createCombo((Composite)c, (String[])this.attributeTypesAndOids, (int)-1, (int)1);
        if (this.currentAttribute != null) {
            this.typeOrOidCombo.setText(this.currentAttribute.getAttributeNumericOidOrName());
        }
        this.typeOrOidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeDialog.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        this.getButton(0).setEnabled(!"".equals(this.typeOrOidCombo.getText()));
    }

    public BinaryAttribute getAttribute() {
        return this.returnAttribute;
    }
}

