/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserUniversalListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectEntryDialog
extends Dialog {
    private String title;
    private IEntry rootEntry;
    private IEntry initialEntry;
    private IEntry selectedEntry;
    private BrowserConfiguration browserConfiguration;
    private BrowserUniversalListener browserUniversalListener;
    private BrowserActionGroup browserActionGroup;
    private BrowserWidget browserWidget;

    public SelectEntryDialog(Shell parentShell, String title, IEntry rootEntry, IEntry initialEntry) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.title = title;
        this.rootEntry = rootEntry;
        this.initialEntry = initialEntry;
        this.selectedEntry = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public boolean close() {
        if (this.browserWidget != null) {
            this.browserConfiguration.dispose();
            this.browserConfiguration = null;
            this.browserActionGroup.deactivateGlobalActionHandlers();
            this.browserActionGroup.dispose();
            this.browserActionGroup = null;
            this.browserUniversalListener.dispose();
            this.browserUniversalListener = null;
            this.browserWidget.dispose();
            this.browserWidget = null;
        }
        return super.close();
    }

    protected void okPressed() {
        this.selectedEntry = this.initialEntry;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selectedEntry = null;
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        this.browserConfiguration = new BrowserConfiguration();
        this.browserWidget = new BrowserWidget(this.browserConfiguration, null);
        this.browserWidget.createWidget(composite);
        this.browserWidget.setInput(new IEntry[]{this.rootEntry});
        this.browserActionGroup = new BrowserActionGroup(this.browserWidget, this.browserConfiguration);
        this.browserActionGroup.fillToolBar(this.browserWidget.getToolBarManager());
        this.browserActionGroup.fillMenu(this.browserWidget.getMenuManager());
        this.browserActionGroup.fillContextMenu(this.browserWidget.getContextMenuManager());
        this.browserActionGroup.activateGlobalActionHandlers();
        this.browserUniversalListener = new BrowserUniversalListener(this.browserWidget.getViewer());
        this.browserWidget.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (o instanceof IEntry) {
                        SelectEntryDialog.this.initialEntry = (IEntry)o;
                    } else if (o instanceof ISearchResult) {
                        SelectEntryDialog.this.initialEntry = ((ISearchResult)o).getEntry();
                    }
                }
            }
        });
        this.browserWidget.getViewer().expandToLevel(2);
        if (this.initialEntry != null) {
            IEntry entry = this.initialEntry;
            this.browserWidget.getViewer().reveal((Object)entry);
            this.browserWidget.getViewer().refresh((Object)entry, true);
            this.browserWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)entry), true);
            this.browserWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)entry), true);
        }
        SelectEntryDialog.applyDialogFont((Control)composite);
        this.browserWidget.setFocus();
        return composite;
    }

    public IEntry getSelectedEntry() {
        return this.selectedEntry;
    }
}

