/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.DnBuilderWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MoveEntriesDialog
extends Dialog
implements WidgetModifyListener {
    private static final String DIALOG_TITLE = Messages.getString("MoveEntriesDialog.MoveEntries");
    private IEntry[] entries;
    private DnBuilderWidget dnBuilderWidget;
    private Button okButton;
    private LdapDN parentDn;

    public MoveEntriesDialog(Shell parentShell, IEntry[] entries) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.entries = entries;
        this.parentDn = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    public boolean close() {
        this.dnBuilderWidget.removeWidgetModifyListener(this);
        this.dnBuilderWidget.dispose();
        return super.close();
    }

    protected void okPressed() {
        this.parentDn = this.dnBuilderWidget.getParentDn();
        this.dnBuilderWidget.saveDialogSettings();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300) * 3 / 2;
        composite.setLayoutData((Object)gd);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("MoveEntriesDialog.MoveEntriesDescription"), (int)1);
        this.dnBuilderWidget = new DnBuilderWidget(false, true);
        this.dnBuilderWidget.addWidgetModifyListener(this);
        this.dnBuilderWidget.createContents(composite);
        this.dnBuilderWidget.setInput(this.entries[0].getBrowserConnection(), null, null, DnUtils.getParent((LdapDN)this.entries[0].getDn()));
        MoveEntriesDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void widgetModified(WidgetModifyEvent event) {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.dnBuilderWidget.getParentDn() != null);
        }
    }

    public LdapDN getParentDn() {
        return this.parentDn;
    }
}

