/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HexDialog
extends Dialog {
    private static final String DIALOG_TITLE = Messages.getString("HexDialog.HexEditor");
    private static final int LOAD_BUTTON_ID = 9998;
    private static final int SAVE_BUTTON_ID = 9999;
    private byte[] currentData;
    private byte[] returnData;
    private Text hexText;

    public HexDialog(Shell parentShell, byte[] initialData) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.currentData = initialData;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.returnData = this.currentData;
        } else if (buttonId == 9999) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText(Messages.getString("HexDialog.SaveData"));
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                try {
                    File file = new File(returnedFileName);
                    FileUtils.writeByteArrayToFile((File)file, (byte[])this.currentData);
                }
                catch (IOException e) {
                    ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, BrowserCommonConstants.PLUGIN_ID, 4, Messages.getString("HexDialog.CantWriteToFile"), (Throwable)e));
                }
            }
        } else if (buttonId == 9998) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            fileDialog.setText(Messages.getString("HexDialog.LoadData"));
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                try {
                    File file = new File(returnedFileName);
                    this.currentData = FileUtils.readFileToByteArray((File)file);
                    this.hexText.setText(this.toFormattedHex(this.currentData));
                }
                catch (IOException e) {
                    ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, BrowserCommonConstants.PLUGIN_ID, 4, Messages.getString("HexDialog.CantReadFile"), (Throwable)e));
                }
            }
        } else {
            this.returnData = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/hexeditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 9998, Messages.getString("HexDialog.LoadDataButton"), false);
        this.createButton(parent, 9999, Messages.getString("HexDialog.SaveDataButton"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.hexText = new Text(composite, 2826);
        this.hexText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.hexText.setText(this.toFormattedHex(this.currentData));
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(480);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        this.hexText.setLayoutData((Object)gd);
        HexDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private String toFormattedHex(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String s;
            int b = data[i];
            if (b < 0) {
                b = 256 + b;
            }
            if ((s = Integer.toHexString(b)).length() == 1) {
                s = "0" + s;
            }
            sb.append(s).append(" ");
            if ((i + 1) % 8 == 0) {
                sb.append(" ");
            }
            if (i == data.length - 1) {
                while ((i + 1) % 16 != 0) {
                    sb.append("   ");
                    if ((i + 1) % 8 == 0) {
                        sb.append(" ");
                    }
                    ++i;
                }
                sb.append(" ");
            }
            if ((i + 1) % 16 == 0) {
                sb.append("   ");
                for (int x = i - 16 + 1; x <= i && x < data.length; ++x) {
                    if (data[x] > 32 && data[x] < 127) {
                        sb.append((char)data[x]);
                    } else {
                        sb.append('.');
                    }
                    if ((x + 1) % 8 != 0) continue;
                    sb.append(" ");
                }
            }
            if ((i + 1) % 16 != 0) continue;
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public byte[] getData() {
        return this.returnData;
    }
}

