/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.FilterWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FilterWidgetDialog
extends Dialog {
    private String title;
    private IBrowserConnection connection;
    private FilterWidget filterWidget;
    private String filter;
    private Label errorMessageLabel;

    public FilterWidgetDialog(Shell parentShell, String title, String filter, IBrowserConnection connection) {
        super(parentShell);
        this.title = title;
        this.filter = filter;
        this.connection = connection;
        this.setShellStyle(67696);
    }

    public String getFilter() {
        return this.filter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/filtereditor.gif"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.filter = this.filterWidget.getFilter();
            this.filterWidget.saveDialogSettings();
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        Composite inner = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        inner.setLayout((Layout)gridLayout);
        gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        inner.setLayoutData((Object)gd);
        this.filterWidget = new FilterWidget(this.filter != null ? this.filter : "");
        this.filterWidget.createWidget(inner);
        this.filterWidget.setBrowserConnection(this.connection);
        this.filterWidget.setFocus();
        this.filterWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                FilterWidgetDialog.this.validate();
            }
        });
        this.errorMessageLabel = BaseWidgetUtils.createLabel((Composite)inner, (String)Messages.getString("FilterWidgetDialog.EnterValidFilter"), (int)2);
        this.validate();
        return composite;
    }

    protected void validate() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.filterWidget.getFilter() != null);
        }
        this.errorMessageLabel.setText(this.filterWidget.getFilter() == null ? Messages.getString("FilterWidgetDialog.EnterValidFilter") : "");
    }
}

