/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DnDialog
extends Dialog {
    private String title;
    private String description;
    private EntryWidget entryWidget;
    private IBrowserConnection connection;
    private LdapDN dn;

    public DnDialog(Shell parentShell, String title, String description, IBrowserConnection connection, LdapDN dn) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.title = title;
        this.description = description;
        this.connection = connection;
        this.dn = dn;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        shell.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/dneditor.gif"));
    }

    protected void okPressed() {
        this.dn = this.entryWidget.getDn();
        this.entryWidget.saveDialogSettings();
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateWidgets();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300) * 3 / 2;
        composite.setLayoutData((Object)gd);
        if (this.description != null) {
            BaseWidgetUtils.createLabel((Composite)composite, (String)this.description, (int)1);
        }
        Composite innerComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        this.entryWidget = new EntryWidget(this.connection, this.dn);
        this.entryWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                DnDialog.this.updateWidgets();
            }
        });
        this.entryWidget.createWidget(innerComposite);
        DnDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateWidgets() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.entryWidget.getDn() != null && !"".equals(this.entryWidget.getDn().toString()));
        }
    }

    public LdapDN getDn() {
        return this.dn;
    }
}

