/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserEntryPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSearchResultPage;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class UpAction
extends BrowserAction {
    protected TreeViewer viewer;

    public UpAction(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public String getText() {
        return Messages.getString("UpAction.Up");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/parent.gif");
    }

    public String getCommandId() {
        return BrowserCommonConstants.CMD_OPEN_SEARCH_RESULT;
    }

    public void run() {
        IEntry[] entries = this.getSelectedEntries();
        ISearch[] searches = this.getSelectedSearches();
        ISearchResult[] searchResults = this.getSelectedSearchResults();
        IBookmark[] bookmarks = this.getSelectedBookmarks();
        BrowserEntryPage[] browserEntryPages = this.getSelectedBrowserEntryPages();
        BrowserSearchResultPage[] browserSearchResultPages = this.getSelectedBrowserSearchResultPages();
        Object selection = null;
        if (entries.length > 0) {
            selection = entries[0];
        } else if (searches.length > 0) {
            selection = searches[0];
        } else if (searchResults.length > 0) {
            selection = searchResults[0];
        } else if (bookmarks.length > 0) {
            selection = bookmarks[0];
        } else if (browserEntryPages.length > 0) {
            selection = browserEntryPages[0];
        } else if (browserSearchResultPages.length > 0) {
            selection = browserSearchResultPages[0];
        }
        if (selection != null) {
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
            Object newSelection = contentProvider.getParent(selection);
            this.viewer.reveal(newSelection);
            this.viewer.setSelection((ISelection)new StructuredSelection(newSelection), true);
        }
    }

    public boolean isEnabled() {
        IEntry[] entries = this.getSelectedEntries();
        ISearch[] searches = this.getSelectedSearches();
        ISearchResult[] searchResults = this.getSelectedSearchResults();
        IBookmark[] bookmarks = this.getSelectedBookmarks();
        BrowserEntryPage[] browserEntryPages = this.getSelectedBrowserEntryPages();
        BrowserSearchResultPage[] browserSearchResultPages = this.getSelectedBrowserSearchResultPages();
        return entries.length > 0 || searches.length > 0 || searchResults.length > 0 || bookmarks.length > 0 || browserEntryPages.length > 0 || browserSearchResultPages.length > 0;
    }
}

