/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class SelectAllAction
extends BrowserAction {
    private Viewer viewer;

    public SelectAllAction(Viewer viewer) {
        this.viewer = viewer;
    }

    public String getText() {
        return Messages.getString("SelectAllAction.SelectAll");
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getCommandId() {
        return "org.eclipse.ui.edit.selectAll";
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        if (this.getInput() != null && this.getInput() instanceof IEntry) {
            ArrayList<Object> selectionList = new ArrayList<Object>();
            IAttribute[] attributes = ((IEntry)this.getInput()).getAttributes();
            if (attributes != null) {
                selectionList.addAll(Arrays.asList(attributes));
                for (int i = 0; i < attributes.length; ++i) {
                    selectionList.addAll(Arrays.asList(attributes[i].getValues()));
                }
            }
            StructuredSelection selection = new StructuredSelection(selectionList);
            this.viewer.setSelection((ISelection)selection);
        } else if (this.getInput() != null && this.getInput() instanceof ConnectionManager) {
            StructuredSelection selection = new StructuredSelection((Object[])((ConnectionManager)this.getInput()).getConnections());
            this.viewer.setSelection((ISelection)selection);
        } else if (this.getSelectedConnections().length > 0 && this.viewer.getInput() instanceof ConnectionManager) {
            StructuredSelection selection = new StructuredSelection((Object[])((ConnectionManager)this.viewer.getInput()).getConnections());
            this.viewer.setSelection((ISelection)selection);
        }
    }
}

