/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshAction
extends BrowserAction {
    @Override
    public String getText() {
        List<IEntry> entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IEntry entryInput = this.getEntryInput();
        ISearch searchInput = this.getSearchInput();
        if (entries.size() > 0 && searches.length == 0 && entryInput == null && searchInput == null) {
            return entries.size() == 1 ? Messages.getString("RefreshAction.ReloadEntry") : Messages.getString("RefreshAction.ReloadEntries");
        }
        if (searches.length > 0 && entries.size() == 0 && entryInput == null && searchInput == null) {
            boolean searchAgain = true;
            for (int i = 0; i < searches.length; ++i) {
                if (searches[i].getSearchResults() != null) continue;
                searchAgain = false;
                break;
            }
            if (searchAgain) {
                return Messages.getString("RefreshAction.SearchAgain");
            }
            return searches.length == 1 ? Messages.getString("RefreshAction.PerformSearch") : Messages.getString("RefreshAction.PerformSearches");
        }
        if (entryInput != null && searches.length == 0 && entries.size() == 0 && searchInput == null) {
            return Messages.getString("RefreshAction.RelaodAttributes");
        }
        if (searchInput != null && searches.length == 0 && entryInput == null) {
            return searchInput.getSearchResults() == null ? Messages.getString("RefreshAction.PerformSearch") : Messages.getString("RefreshAction.SearchAgain");
        }
        return Messages.getString("RefreshAction.Refresh");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/refresh.gif");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.file.refresh";
    }

    @Override
    public void run() {
        List<IEntry> entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IEntry entryInput = this.getEntryInput();
        ISearch searchInput = this.getSearchInput();
        if (entries.size() > 0) {
            for (IEntry entry : entries) {
                IContinuation continuation;
                if (!(entry instanceof IContinuation) || (continuation = (IContinuation)entry).getState() == IContinuation.State.RESOLVED) continue;
                continuation.resolve();
            }
            InitializeChildrenRunnable initializeChildrenRunnable = new InitializeChildrenRunnable(true, entries.toArray(new IEntry[0]));
            new StudioBrowserJob(new StudioRunnableWithProgress[]{initializeChildrenRunnable}).execute();
        }
        if (searches.length > 0) {
            for (ISearch search : searches) {
                IContinuation continuation;
                search.setSearchResults(null);
                if (!(search instanceof IContinuation) || (continuation = (IContinuation)search).getState() == IContinuation.State.RESOLVED) continue;
                continuation.resolve();
            }
            new StudioBrowserJob(new StudioRunnableWithProgress[]{new SearchRunnable(searches)}).execute();
        }
        if (entryInput != null) {
            IEntry entry = entryInput.getBrowserConnection().getEntryFromCache(entryInput.getDn());
            new StudioBrowserJob(new StudioRunnableWithProgress[]{new InitializeAttributesRunnable(new IEntry[]{entry})}).execute();
        }
        if (searchInput != null) {
            ISearch search = searchInput.getBrowserConnection().getSearchManager().getSearch(searchInput.getName());
            search.setSearchResults(null);
            new StudioBrowserJob(new StudioRunnableWithProgress[]{new SearchRunnable(new ISearch[]{search})}).execute();
        }
    }

    @Override
    public boolean isEnabled() {
        List<IEntry> entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IEntry entryInput = this.getEntryInput();
        ISearch searchInput = this.getSearchInput();
        return entries.size() > 0 || searches.length > 0 || entryInput != null || searchInput != null;
    }

    protected List<IEntry> getEntries() {
        ArrayList<IEntry> entries = new ArrayList<IEntry>();
        entries.addAll(Arrays.asList(this.getSelectedEntries()));
        for (ISearchResult iSearchResult : this.getSelectedSearchResults()) {
            entries.add(iSearchResult.getEntry());
        }
        for (ISearchResult iSearchResult : this.getSelectedBookmarks()) {
            entries.add(iSearchResult.getEntry());
        }
        return entries;
    }

    protected ISearch[] getSearches() {
        return this.getSelectedSearches();
    }

    private IEntry getEntryInput() {
        if (this.getInput() != null && this.getInput() instanceof IEntry) {
            return (IEntry)this.getInput();
        }
        return null;
    }

    private ISearch getSearchInput() {
        if (this.getInput() != null && this.getInput() instanceof ISearch) {
            return (ISearch)this.getInput();
        }
        return null;
    }
}

