/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.impl.QuickSearch;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class OpenQuickSearchAction
extends BrowserAction {
    public void run() {
        IBrowserConnection browserConnection = this.getBrowserConnection();
        if (browserConnection != null) {
            IQuickSearch quickSearch = browserConnection.getSearchManager().getQuickSearch();
            if (quickSearch == null) {
                quickSearch = new QuickSearch((IEntry)browserConnection.getRootDSE(), browserConnection);
                browserConnection.getSearchManager().setQuickSearch(quickSearch);
            }
            String pageId = BrowserCommonConstants.PROP_SEARCH;
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)quickSearch, (String)pageId, null, null);
            String title = quickSearch.getName();
            if (dialog != null) {
                title = Utils.shorten((String)title, (int)30);
            }
            dialog.getShell().setText(NLS.bind((String)Messages.getString("PropertiesAction.PropertiesForX"), (Object)title));
            dialog.open();
        }
    }

    public String getText() {
        return Messages.getString("OpenQuickSearchAction.OpenQuickSearch");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/quicksearch.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getBrowserConnection() != null;
    }

    private IBrowserConnection getBrowserConnection() {
        if (this.getInput() instanceof IBrowserConnection) {
            return (IBrowserConnection)this.getInput();
        }
        if (this.getSelectedSearchResults().length > 0) {
            return this.getSelectedSearchResults()[0].getEntry().getBrowserConnection();
        }
        if (this.getSelectedEntries().length > 0) {
            return this.getSelectedEntries()[0].getBrowserConnection();
        }
        if (this.getSelectedSearches().length > 0) {
            return this.getSelectedSearches()[0].getBrowserConnection();
        }
        return null;
    }
}

