/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.common.dialogs.DeleteDialog;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.jobs.DeleteEntriesJob;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends BrowserAction {
    @Override
    public String getText() {
        try {
            Collection<IEntry> entries = this.getEntries();
            ISearch[] searches = this.getSearches();
            IBookmark[] bookmarks = this.getBookmarks();
            Collection<IValue> values = this.getValues();
            if (entries.size() > 0 && searches.length == 0 && bookmarks.length == 0 && values.size() == 0) {
                return entries.size() > 1 ? Messages.getString("DeleteAction.DeleteEntries") : Messages.getString("DeleteAction.DeleteEntry");
            }
            if (searches.length > 0 && entries.size() == 0 && bookmarks.length == 0 && values.size() == 0) {
                return searches.length > 1 ? Messages.getString("DeleteAction.DeleteSearches") : Messages.getString("DeleteAction.DeleteSearch");
            }
            if (bookmarks.length > 0 && entries.size() == 0 && searches.length == 0 && values.size() == 0) {
                return bookmarks.length > 1 ? Messages.getString("DeleteAction.DeleteBookmarks") : Messages.getString("DeleteAction.DeleteBookmark");
            }
            if (values.size() > 0 && entries.size() == 0 && searches.length == 0 && bookmarks.length == 0) {
                return values.size() > 1 ? Messages.getString("DeleteAction.DeleteValues") : Messages.getString("DeleteAction.DeleteValue");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Messages.getString("DeleteAction.Delete");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.delete";
    }

    @Override
    public void run() {
        try {
            Collection<IEntry> entries = this.getEntries();
            ISearch[] searches = this.getSearches();
            IBookmark[] bookmarks = this.getBookmarks();
            Collection<IValue> values = this.getValues();
            StringBuffer message = new StringBuffer();
            boolean askForTreeDeleteControl = false;
            if (entries.size() > 0) {
                this.appendEntriesWarnMessage(message, entries);
                if (entries.iterator().next().getBrowserConnection().getRootDSE().isControlSupported(StudioControl.TREEDELETE_CONTROL.getOid())) {
                    askForTreeDeleteControl = true;
                }
            }
            if (searches.length > 0) {
                this.appendSearchesWarnMessage(message, searches);
            }
            if (bookmarks.length > 0) {
                this.appendBookmarsWarnMessage(message, bookmarks);
            }
            if (values.size() > 0) {
                boolean emptyValuesOnly = true;
                for (IValue value : values) {
                    if (value.isEmpty()) continue;
                    emptyValuesOnly = false;
                }
                if (!emptyValuesOnly) {
                    this.appendValuesWarnMessage(message, values);
                }
            }
            DeleteDialog dialog = new DeleteDialog(this.getShell(), this.getText(), message.toString(), askForTreeDeleteControl);
            if (message.length() == 0 || dialog.open() == 0) {
                if (entries.size() > 0) {
                    this.deleteEntries(entries, dialog.isUseTreeDeleteControl());
                }
                if (searches.length > 0) {
                    this.deleteSearches(searches);
                }
                if (bookmarks.length > 0) {
                    this.deleteBookmarks(bookmarks);
                }
                if (values.size() > 0) {
                    this.deleteValues(values);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isEnabled() {
        try {
            Collection<IEntry> entries = this.getEntries();
            ISearch[] searches = this.getSearches();
            IBookmark[] bookmarks = this.getBookmarks();
            Collection<IValue> values = this.getValues();
            return entries.size() + searches.length + bookmarks.length + values.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Collection<IEntry> getEntries() {
        LinkedHashSet<IEntry> entriesSet = new LinkedHashSet<IEntry>();
        for (IEntry iEntry : this.getSelectedEntries()) {
            entriesSet.add(iEntry);
        }
        for (IEntry iEntry : this.getSelectedSearchResults()) {
            entriesSet.add(iEntry.getEntry());
        }
        Iterator iterator = entriesSet.iterator();
        while (iterator.hasNext()) {
            IEntry entry = (IEntry)iterator.next();
            if (!entriesSet.contains(entry.getParententry())) continue;
            iterator.remove();
        }
        return entriesSet;
    }

    protected void appendEntriesWarnMessage(StringBuffer message, Collection<IEntry> entries) {
        for (IEntry entry : entries) {
            if (!(entry instanceof IRootDSE)) continue;
            message.append(Messages.getString("DeleteAction.DeleteRootDSE"));
            message.append(BrowserCoreConstants.LINE_SEPARATOR);
            message.append(BrowserCoreConstants.LINE_SEPARATOR);
        }
        if (entries.size() <= 5) {
            message.append(entries.size() == 1 ? Messages.getString("DeleteAction.DeleteEntryQuestion") : Messages.getString("DeleteAction.DeleteEntriesQuestion"));
            for (IEntry entry : entries) {
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append("  - ");
                message.append(entry.getDn().getUpName());
            }
        } else {
            message.append(Messages.getString("DeleteAction.DeleteSelectedEntriesQuestion"));
        }
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
    }

    protected void deleteEntries(Collection<IEntry> entries, boolean useTreeDeleteControl) {
        new DeleteEntriesJob(entries, useTreeDeleteControl).execute();
    }

    protected ISearch[] getSearches() {
        return this.getSelectedSearches();
    }

    protected void appendSearchesWarnMessage(StringBuffer message, ISearch[] searches) {
        if (searches.length <= 5) {
            message.append(searches.length == 1 ? Messages.getString("DeleteAction.DeleteSearchQuestion") : Messages.getString("DeleteAction.DeleteSearchesQuestion"));
            for (int i = 0; i < searches.length; ++i) {
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append("  - ");
                message.append(searches[i].getName());
            }
        } else {
            message.append(Messages.getString("DeleteAction.DeleteSelectedSearchesQuestion"));
        }
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
    }

    protected void deleteSearches(ISearch[] searches) {
        for (ISearch search : searches) {
            search.getBrowserConnection().getSearchManager().removeSearch(search);
        }
    }

    protected IBookmark[] getBookmarks() {
        return this.getSelectedBookmarks();
    }

    protected void appendBookmarsWarnMessage(StringBuffer message, IBookmark[] bookmarks) {
        if (bookmarks.length <= 5) {
            message.append(bookmarks.length == 1 ? Messages.getString("DeleteAction.DeleteBookmarkQuestion") : Messages.getString("DeleteAction.DeleteBookmarksQuestion"));
            for (int i = 0; i < bookmarks.length; ++i) {
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append("  - ");
                message.append(bookmarks[i].getName());
            }
        } else {
            message.append(Messages.getString("DeleteAction.DeleteSelectedBookmarksQuestion"));
        }
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
    }

    protected void deleteBookmarks(IBookmark[] bookmarks) {
        for (IBookmark bookmark : bookmarks) {
            bookmark.getBrowserConnection().getBookmarkManager().removeBookmark(bookmark);
        }
    }

    protected Collection<IValue> getValues() throws Exception {
        LinkedHashSet<IValue> valueList = new LinkedHashSet<IValue>();
        for (IAttribute iAttribute : this.getSelectedAttributes()) {
            if (iAttribute == null || iAttribute.getValueSize() <= 0) continue;
            valueList.addAll(Arrays.asList(iAttribute.getValues()));
        }
        for (IAttribute iAttribute : this.getSelectedAttributeHierarchies()) {
            for (IAttribute attribute : iAttribute) {
                if (attribute == null || attribute.getValueSize() <= 0) continue;
                valueList.addAll(Arrays.asList(attribute.getValues()));
            }
        }
        for (IAttribute iAttribute : this.getSelectedValues()) {
            valueList.add((IValue)iAttribute);
        }
        return valueList;
    }

    protected void appendValuesWarnMessage(StringBuffer message, Collection<IValue> values) {
        HashMap<AttributeTypeDescription, Integer> attributeNameToSelectedValuesCountMap = new HashMap<AttributeTypeDescription, Integer>();
        HashSet<ObjectClassDescription> selectedObjectClasses = new HashSet<ObjectClassDescription>();
        for (IValue value : values) {
            String type = value.getAttribute().getType();
            AttributeTypeDescription atd = value.getAttribute().getAttributeTypeDescription();
            AttributeHierarchy ah = value.getAttribute().getEntry().getAttributeWithSubtypes(type);
            if (value.isRdnPart()) {
                message.append(NLS.bind((String)Messages.getString("DeleteAction.DeletePartOfRDN"), (Object)value.toString()));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (value.getAttribute().isObjectClassAttribute()) {
                selectedObjectClasses.add(value.getAttribute().getEntry().getBrowserConnection().getSchema().getObjectClassDescription(value.getStringValue()));
            }
            if (!attributeNameToSelectedValuesCountMap.containsKey(atd)) {
                attributeNameToSelectedValuesCountMap.put(atd, new Integer(0));
            }
            int count = (Integer)attributeNameToSelectedValuesCountMap.get(atd) + 1;
            attributeNameToSelectedValuesCountMap.put(atd, new Integer(count));
            if (value.getAttribute().isObjectClassAttribute() && count >= ah.getValueSize()) {
                message.append(Messages.getString("DeleteAction.DeleteObjectClass"));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                continue;
            }
            if (value.getAttribute().isMustAttribute() && count >= ah.getValueSize()) {
                message.append(NLS.bind((String)Messages.getString("DeleteAction.DeleteMust"), (Object)type));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (SchemaUtils.isModifiable((AttributeTypeDescription)atd)) continue;
            message.append(NLS.bind((String)Messages.getString("DeleteAction.DeleteNonModifiable"), (Object)type));
            message.append(BrowserCoreConstants.LINE_SEPARATOR);
            message.append(BrowserCoreConstants.LINE_SEPARATOR);
        }
        if (values.size() > 0 && !selectedObjectClasses.isEmpty()) {
            IAttribute[] attributes;
            IEntry entry = values.iterator().next().getAttribute().getEntry();
            Schema schema = entry.getBrowserConnection().getSchema();
            Collection remainingObjectClasses = entry.getObjectClassDescriptions();
            remainingObjectClasses.removeAll(selectedObjectClasses);
            HashSet<AttributeTypeDescription> remainingAttributeSet = new HashSet<AttributeTypeDescription>();
            for (ObjectClassDescription ocd : remainingObjectClasses) {
                Collection mustAttrs = SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive((ObjectClassDescription)ocd, (Schema)schema);
                for (String mustAttr : mustAttrs) {
                    AttributeTypeDescription atd = entry.getBrowserConnection().getSchema().getAttributeTypeDescription(mustAttr);
                    remainingAttributeSet.add(atd);
                }
                Collection mayAttrs = SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive((ObjectClassDescription)ocd, (Schema)schema);
                for (String mayAttr : mayAttrs) {
                    AttributeTypeDescription atd = entry.getBrowserConnection().getSchema().getAttributeTypeDescription(mayAttr);
                    remainingAttributeSet.add(atd);
                }
            }
            for (IAttribute attribute : attributes = entry.getAttributes()) {
                if (!attribute.isMayAttribute() && !attribute.isMustAttribute() || remainingAttributeSet.contains(attribute.getAttributeTypeDescription())) continue;
                message.append(NLS.bind((String)Messages.getString("DeleteAction.DeleteNeededObjectClass"), (Object)attribute.getDescription()));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
        }
        if (values.size() <= 5) {
            message.append(values.size() == 1 ? Messages.getString("DeleteAction.DeleteAttributeQuestion") : Messages.getString("DeleteAction.DeleteAttributesQuestion"));
            for (IValue value : values) {
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append("  - ");
                message.append(value.toString());
            }
        } else {
            message.append(Messages.getString("DeleteAction.DeleteSelectedAttributesQuestion"));
        }
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
        message.append(BrowserCoreConstants.LINE_SEPARATOR);
    }

    protected void deleteValues(Collection<IValue> values) {
        new CompoundModification().deleteValues(values);
    }
}

