/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.schema.AttributeValueEditorRelation;
import org.apache.directory.studio.ldapbrowser.core.model.schema.ObjectClassIconPair;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SyntaxValueEditorRelation;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class BrowserCommonPreferencesInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
        store.setDefault("countLimit", 1000);
        store.setDefault("timeLimit", 0);
        RGB rgbBlack = Display.getDefault().getSystemColor(2).getRGB();
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        FontData fontDataNormal = new FontData(fontData[0].getName(), fontData[0].getHeight(), 0);
        FontData fontDataItalic = new FontData(fontData[0].getName(), fontData[0].getHeight(), 2);
        FontData fontDataBold = new FontData(fontData[0].getName(), fontData[0].getHeight(), 1);
        FontData fontDataBoldItalic = new FontData(fontData[0].getName(), fontData[0].getHeight(), 3);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"objectClassColor", (RGB)rgbBlack);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"objectClassFont", (FontData)fontDataBoldItalic);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"mustAttributeColor", (RGB)rgbBlack);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"mustAttributeFont", (FontData)fontDataBold);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"mayAttributeColor", (RGB)rgbBlack);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"mayAttributeFont", (FontData)fontDataNormal);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"operationalAttributeColor", (RGB)rgbBlack);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"operationalAttributeFont", (FontData)fontDataItalic);
        store.setDefault("showRawValues", false);
        ArrayList<AttributeValueEditorRelation> avprs = new ArrayList<AttributeValueEditorRelation>();
        ArrayList<SyntaxValueEditorRelation> svprs = new ArrayList<SyntaxValueEditorRelation>();
        Collection<ValueEditorManager.ValueEditorExtension> valueEditorExtensions = ValueEditorManager.getValueEditorExtensions();
        for (ValueEditorManager.ValueEditorExtension vee : valueEditorExtensions) {
            for (String attributeType : vee.attributeTypes) {
                AttributeValueEditorRelation aver = new AttributeValueEditorRelation(attributeType, vee.className);
                avprs.add(aver);
            }
            for (String syntaxOid : vee.syntaxOids) {
                SyntaxValueEditorRelation sver = new SyntaxValueEditorRelation(syntaxOid, vee.className);
                svprs.add(sver);
            }
        }
        BrowserCommonActivator.getDefault().getValueEditorsPreferences().setDefaultAttributeValueEditorRelations(avprs.toArray(new AttributeValueEditorRelation[0]));
        BrowserCommonActivator.getDefault().getValueEditorsPreferences().setDefaultSyntaxValueEditorRelations(svprs.toArray(new SyntaxValueEditorRelation[0]));
        store.setDefault("browserExpandBaseEntries", false);
        store.setDefault("browserEnableFolding", true);
        store.setDefault("browserFoldingSize", 100);
        store.setDefault("browserEntryLabel", 1);
        store.setDefault("browserEntryAbbreviate", true);
        store.setDefault("browserentryAbbreviateMaxLength", 50);
        store.setDefault("browserSearchResultLabel", 0);
        store.setDefault("browserWearchResultAbbreviate", true);
        store.setDefault("browserSearchResultAbbreviateMaxLength", 50);
        store.setDefault("browserShowQuickSearch", true);
        store.setDefault("browserShowDIT", true);
        store.setDefault("browserShowSearches", true);
        store.setDefault("browserShowBookmarks", true);
        store.setDefault("browserShowDirectoryMetaEntries", false);
        store.setDefault("browserSortBy", 2);
        store.setDefault("browserSortOrder", 1);
        store.setDefault("browserSortLimit", 10000);
        store.setDefault("browserLeafEntriesFirst", true);
        store.setDefault("browserContainerEntriesFirst", false);
        store.setDefault("browserMetaEntriesLast", true);
        ObjectClassIconPair[] objectClassIcons = new ObjectClassIconPair[]{new ObjectClassIconPair(new String[]{"2.5.6.6", "2.5.6.7", "2.16.840.1.113730.3.2.2"}, "resources/icons/entry_person.gif"), new ObjectClassIconPair(new String[]{"1.3.6.1.1.1.2.0"}, "resources/icons/entry_person.gif"), new ObjectClassIconPair(new String[]{"2.5.6.4"}, "resources/icons/entry_org.gif"), new ObjectClassIconPair(new String[]{"2.5.6.5"}, "resources/icons/entry_org.gif"), new ObjectClassIconPair(new String[]{"2.5.6.2"}, "resources/icons/entry_dc.gif"), new ObjectClassIconPair(new String[]{"2.5.6.3"}, "resources/icons/entry_dc.gif"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.1466.344"}, "resources/icons/entry_dc.gif"), new ObjectClassIconPair(new String[]{"0.9.2342.19200300.100.4.13"}, "resources/icons/entry_dc.gif"), new ObjectClassIconPair(new String[]{"2.5.6.9"}, "resources/icons/entry_group.gif"), new ObjectClassIconPair(new String[]{"2.5.6.17"}, "resources/icons/entry_group.gif"), new ObjectClassIconPair(new String[]{"1.3.6.1.1.1.2.2"}, "resources/icons/entry_group.gif"), new ObjectClassIconPair(new String[]{"2.5.17.0"}, "resources/icons/browser_schemabrowsereditor.gif"), new ObjectClassIconPair(new String[]{"2.16.840.1.113730.3.2.6"}, "resources/icons/entry_ref.png"), new ObjectClassIconPair(new String[]{"2.5.6.1"}, "resources/icons/entry_alias.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.11"}, "resources/icons/browser_schemabrowsereditor.gif"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.2"}, "resources/icons/ocd.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.3"}, "resources/icons/atd.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.5"}, "resources/icons/mrd.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.10"}, "resources/icons/syntax_checker.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.4"}, "resources/icons/lsd.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.13"}, "resources/icons/comparator.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.12"}, "resources/icons/normalizer.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.9"}, "resources/icons/dit_content_rule.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.6"}, "resources/icons/dit_structure_rule.png"), new ObjectClassIconPair(new String[]{"1.3.6.1.4.1.18060.0.4.0.3.7"}, "resources/icons/name_form.png"), new ObjectClassIconPair(new String[]{"1.2.840.113556.1.5.9"}, "resources/icons/entry_person.gif"), new ObjectClassIconPair(new String[]{"1.2.840.113556.1.5.8"}, "resources/icons/entry_group.gif"), new ObjectClassIconPair(new String[]{"1.2.840.113556.1.3.23"}, "resources/icons/entry_org.gif"), new ObjectClassIconPair(new String[]{"1.2.840.113556.1.5.66", "1.2.840.113556.1.5.67"}, "resources/icons/entry_dc.gif"), new ObjectClassIconPair(new String[]{"1.2.840.113556.1.3.13"}, "resources/icons/ocd.png"), new ObjectClassIconPair(new String[]{"1.2.840.113556.1.3.14"}, "resources/icons/atd.png")};
        BrowserCorePlugin.getDefault().getCorePreferences().setDefaultObjectClassIcons(objectClassIcons);
        store.setDefault("entryeditorEnableFolding", true);
        store.setDefault("entryeditorFoldingThreshold", 10);
        store.setDefault("entryeditorAutoExpandFoldedAttributes", false);
        store.setDefault("entryeditorAutoSaveSingleTab", true);
        store.setDefault("entryeditorAutoSaveMultiTab", false);
        store.setDefault("entryeditorObjectClassAndMustAttributesFirst", true);
        store.setDefault("entryeditorOperationalAttributesLast", true);
        store.setDefault("entryeditorDefaultSortBy", 3);
        store.setDefault("entryeditorDefaultSortOrder", 1);
        store.setDefault("formatTableAttributeDelimiter", "\t");
        store.setDefault("formatTableValueDelimiter", "|");
        store.setDefault("formatTableQuoteCharacter", "\"");
        store.setDefault("formatTableLineSeparator", BrowserCoreConstants.LINE_SEPARATOR);
        store.setDefault("formatTableBinaryEncoding", 0);
    }
}

