/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import java.util.Collection;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ItemFirstACIItem;
import org.apache.directory.shared.ldap.aci.ItemPermission;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.aci.UserFirstACIItem;
import org.apache.directory.shared.ldap.aci.UserPermission;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemGeneralComposite;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemItemPermissionsComposite;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemProtectedItemsComposite;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemUserClassesComposite;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemUserPermissionsComposite;
import org.apache.directory.studio.aciitemeditor.widgets.WidgetModifyEvent;
import org.apache.directory.studio.aciitemeditor.widgets.WidgetModifyListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ACIItemVisualEditorComposite
extends ScrolledComposite
implements WidgetModifyListener {
    private Composite composite = null;
    private ACIItemGeneralComposite generalComposite = null;
    private ACIItemUserClassesComposite userFirstUserClassesComposite = null;
    private ACIItemUserPermissionsComposite userFirstUserPermissionsComposite = null;
    private ACIItemProtectedItemsComposite itemFirstProtectedItemsComposite = null;
    private ACIItemItemPermissionsComposite itemFirstItemPermissionsComposite = null;

    public ACIItemVisualEditorComposite(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.createComposite();
        this.setContent((Control)this.composite);
        this.setMinSize(this.composite.computeSize(-1, -1));
    }

    private void createComposite() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)gridData);
        this.generalComposite = new ACIItemGeneralComposite(this.composite, 0);
        this.generalComposite.addWidgetModifyListener(this);
        this.userFirstUserClassesComposite = new ACIItemUserClassesComposite(this.composite, 0);
        this.userFirstUserPermissionsComposite = new ACIItemUserPermissionsComposite(this.composite, 0);
        this.itemFirstProtectedItemsComposite = new ACIItemProtectedItemsComposite(this.composite, 0);
        this.itemFirstItemPermissionsComposite = new ACIItemItemPermissionsComposite(this.composite, 0);
        this.widgetModified(null);
    }

    public void widgetModified(WidgetModifyEvent event) {
        if (this.generalComposite.isItemFirst() && !this.generalComposite.isUserFirst() && !this.itemFirstProtectedItemsComposite.isVisible()) {
            this.userFirstUserClassesComposite.setVisible(false);
            this.userFirstUserPermissionsComposite.setVisible(false);
            this.itemFirstProtectedItemsComposite.setVisible(true);
            this.itemFirstItemPermissionsComposite.setVisible(true);
            this.setMinSize(this.composite.computeSize(-1, -1));
            this.layout(true, true);
        } else if (this.generalComposite.isUserFirst() && !this.generalComposite.isItemFirst() && !this.userFirstUserClassesComposite.isVisible()) {
            this.userFirstUserClassesComposite.setVisible(true);
            this.userFirstUserPermissionsComposite.setVisible(true);
            this.itemFirstProtectedItemsComposite.setVisible(false);
            this.itemFirstItemPermissionsComposite.setVisible(false);
            this.setMinSize(this.composite.computeSize(-1, -1));
            this.layout(true, true);
        } else if (!this.generalComposite.isItemFirst() && !this.generalComposite.isUserFirst()) {
            this.userFirstUserClassesComposite.setVisible(false);
            this.userFirstUserPermissionsComposite.setVisible(false);
            this.itemFirstProtectedItemsComposite.setVisible(false);
            this.itemFirstItemPermissionsComposite.setVisible(false);
            this.setMinSize(this.composite.computeSize(-1, -1));
            this.layout(true, true);
        }
    }

    public void setInput(String input) throws ParseException {
        ACIItemParser parser = new ACIItemParser(null);
        ACIItem aciItem = parser.parse(input);
        if (aciItem != null) {
            this.generalComposite.setIdentificationTag(aciItem.getIdentificationTag());
            this.generalComposite.setPrecedence(aciItem.getPrecedence());
            this.generalComposite.setAuthenticationLevel(aciItem.getAuthenticationLevel());
            if (aciItem instanceof ItemFirstACIItem) {
                ItemFirstACIItem itemFirstACI = (ItemFirstACIItem)aciItem;
                this.generalComposite.setItemFirst();
                this.itemFirstProtectedItemsComposite.setProtectedItems(itemFirstACI.getProtectedItems());
                this.itemFirstItemPermissionsComposite.setItemPermissions(itemFirstACI.getItemPermissions());
            } else if (aciItem instanceof UserFirstACIItem) {
                UserFirstACIItem userFirstACI = (UserFirstACIItem)aciItem;
                this.generalComposite.setUserFirst();
                this.userFirstUserClassesComposite.setUserClasses(userFirstACI.getUserClasses());
                this.userFirstUserPermissionsComposite.setUserPermissions(userFirstACI.getUserPermission());
            }
        }
        this.widgetModified(null);
    }

    public String getInput() throws ParseException {
        String identificationTag = this.generalComposite.getIdentificationTag();
        int precedence = this.generalComposite.getPrecedence();
        AuthenticationLevel authenticationLevel = this.generalComposite.getAuthenticationLevel();
        Object aciItem = null;
        if (this.generalComposite.isUserFirst()) {
            Collection<UserClass> userClasses = this.userFirstUserClassesComposite.getUserClasses();
            Collection<UserPermission> userPermissions = this.userFirstUserPermissionsComposite.getUserPermissions();
            aciItem = new UserFirstACIItem(identificationTag, precedence, authenticationLevel, userClasses, userPermissions);
        } else if (this.generalComposite.isItemFirst()) {
            Collection<ProtectedItem> protectedItems = this.itemFirstProtectedItemsComposite.getProtectedItems();
            Collection<ItemPermission> itemPermissions = this.itemFirstItemPermissionsComposite.getItemPermissions();
            aciItem = new ItemFirstACIItem(identificationTag, precedence, authenticationLevel, protectedItems, itemPermissions);
        } else {
            aciItem = null;
        }
        String aci = "";
        if (aciItem != null) {
            aci = aciItem.toString();
        }
        return aci;
    }

    public void setContext(ACIItemValueWithContext context) {
        this.itemFirstProtectedItemsComposite.setContext(context);
        this.itemFirstItemPermissionsComposite.setContext(context);
        this.userFirstUserClassesComposite.setContext(context);
        this.userFirstUserPermissionsComposite.setContext(context);
    }
}

