/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import org.apache.directory.studio.aciitemeditor.ACIITemConstants;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemSourceEditorComposite;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemVisualEditorComposite;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ACIItemTabFolderComposite
extends Composite {
    public static final int VISUAL_TAB_INDEX = 0;
    public static final int SOURCE_TAB_INDEX = 1;
    private TabFolder tabFolder;
    private TabItem visualTab;
    private Composite visualContainer;
    private ACIItemVisualEditorComposite visualComposite;
    private TabItem sourceTab;
    private Composite sourceContainer;
    private ACIItemSourceEditorComposite sourceComposite;

    public ACIItemTabFolderComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createTabFolder();
        this.createVisualTab();
        this.createSourceTab();
        this.initListeners();
    }

    private void initListeners() {
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemTabFolderComposite.this.tabSelected();
            }
        });
    }

    private void createSourceTab() {
        this.sourceContainer = new Composite((Composite)this.tabFolder, 2048);
        this.sourceContainer.setLayout((Layout)new FillLayout());
        this.sourceComposite = new ACIItemSourceEditorComposite(this.sourceContainer, 0);
        this.sourceTab = new TabItem(this.tabFolder, 0, 1);
        this.sourceTab.setText(Messages.getString("ACIItemTabFolderComposite.source.tab"));
        this.sourceTab.setControl((Control)this.sourceContainer);
    }

    private void createVisualTab() {
        this.visualContainer = new Composite((Composite)this.tabFolder, 0);
        this.visualContainer.setLayout((Layout)new FillLayout());
        this.visualComposite = new ACIItemVisualEditorComposite(this.visualContainer, 0);
        this.visualTab = new TabItem(this.tabFolder, 0, 0);
        this.visualTab.setText(Messages.getString("ACIItemTabFolderComposite.visual.tab"));
        this.visualTab.setControl((Control)this.visualContainer);
    }

    private void createTabFolder() {
        this.tabFolder = new TabFolder((Composite)this, 128);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.tabFolder.setLayout((Layout)mainLayout);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
    }

    private void tabSelected() {
        int index = this.tabFolder.getSelectionIndex();
        if (index == 1) {
            try {
                String input = this.visualComposite.getInput();
                this.sourceComposite.setInput(input);
            }
            catch (ParseException pe) {
                Status status = new Status(4, ACIITemConstants.PLUGIN_ID, 1, Messages.getString("ACIItemTabFolderComposite.error.onVisualEditor"), (Throwable)pe);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("ACIItemTabFolderComposite.error.title"), null, (IStatus)status);
                this.tabFolder.setSelection(0);
            }
        } else if (index == 0) {
            try {
                String input = this.sourceComposite.getInput();
                this.visualComposite.setInput(input);
            }
            catch (ParseException pe) {
                Status status = new Status(4, ACIITemConstants.PLUGIN_ID, 1, Messages.getString("ACIItemTabFolderComposite.error.onSourceEditor"), (Throwable)pe);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("ACIItemTabFolderComposite.error.title"), null, (IStatus)status);
                this.tabFolder.setSelection(1);
            }
        }
    }

    public void setInput(String input) {
        this.sourceComposite.forceSetInput(input);
        try {
            this.visualComposite.setInput(input);
        }
        catch (ParseException pe) {
            Status status = new Status(4, ACIITemConstants.PLUGIN_ID, 1, Messages.getString("ACIItemTabFolderComposite.error.onInput"), (Throwable)pe);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("ACIItemTabFolderComposite.error.title"), null, (IStatus)status);
            this.tabFolder.setSelection(1);
        }
    }

    public String getInput() throws ParseException {
        int index = this.tabFolder.getSelectionIndex();
        if (index == 0) {
            String input = this.visualComposite.getInput();
            return input;
        }
        String input = this.sourceComposite.getInput();
        return input;
    }

    public void setContext(ACIItemValueWithContext context) {
        this.sourceComposite.setContext(context);
        this.visualComposite.setContext(context);
    }

    public void format() {
        this.sourceComposite.format();
    }
}

