/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.sourceeditor.ACISourceViewerConfiguration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ACIItemSourceEditorComposite
extends Composite {
    private SourceViewer sourceEditor;
    private SourceViewerConfiguration configuration;

    public ACIItemSourceEditorComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.createSourceEditor();
    }

    private void createSourceEditor() {
        this.sourceEditor = new SourceViewer((Composite)this, null, null, false, 2816);
        this.configuration = new ACISourceViewerConfiguration();
        this.sourceEditor.configure(this.configuration);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.sourceEditor.getTextWidget().setFont(font);
        Document document = new Document();
        this.sourceEditor.setDocument((IDocument)document);
    }

    public void setInput(String input) throws ParseException {
        ACIItemParser parser = Activator.getDefault().getACIItemParser();
        parser.parse(input);
        this.forceSetInput(input);
    }

    public void forceSetInput(String input) {
        this.sourceEditor.getDocument().set(input);
        Region region = new Region(0, this.sourceEditor.getDocument().getLength());
        this.configuration.getContentFormatter((ISourceViewer)this.sourceEditor).format(this.sourceEditor.getDocument(), (IRegion)region);
    }

    public String getInput() throws ParseException {
        String input = this.forceGetInput();
        input = input.replaceAll("\\n", " ");
        input = input.replaceAll("\\r", " ");
        ACIItemParser parser = Activator.getDefault().getACIItemParser();
        ACIItem aciItem = parser.parse(input);
        String aci = "";
        if (aciItem != null) {
            aci = aciItem.toString();
        }
        return aci;
    }

    public String forceGetInput() {
        return this.sourceEditor.getDocument().get();
    }

    public void setContext(ACIItemValueWithContext context) {
    }

    public void format() {
        Region region = new Region(0, this.sourceEditor.getDocument().getLength());
        this.configuration.getContentFormatter((ISourceViewer)this.sourceEditor).format(this.sourceEditor.getDocument(), (IRegion)region);
    }
}

