/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.MultiValuedDialog;
import org.apache.directory.studio.aciitemeditor.model.ProtectedItemWrapper;
import org.apache.directory.studio.aciitemeditor.model.ProtectedItemWrapperFactory;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACIItemProtectedItemsComposite
extends Composite {
    private ACIItemValueWithContext context;
    private Composite composite = null;
    private Label label = null;
    private Table table = null;
    private CheckboxTableViewer tableViewer = null;
    private Composite buttonComposite = null;
    private Button editButton = null;
    private Button selectAllButton = null;
    private Button deselectAllButton = null;
    private Button reverseSelectionButton = null;
    private ProtectedItemWrapper[] protectedItemWrappers = ProtectedItemWrapperFactory.createProtectedItemWrappers();

    public ACIItemProtectedItemsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.setLayoutData(layoutData);
        this.createComposite();
    }

    private void createComposite() {
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        labelGridData.verticalAlignment = 2;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalSpan = 1;
        gridData.verticalAlignment = 1;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)gridLayout);
        this.label = new Label(this.composite, 0);
        this.label.setText(Messages.getString("ACIItemProtectedItemsComposite.description"));
        this.label.setLayoutData((Object)labelGridData);
        this.createTable();
        this.createButtonComposite();
    }

    private void createTable() {
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        this.table = new Table(this.composite, 2080);
        this.table.setHeaderVisible(false);
        this.table.setLayoutData((Object)tableGridData);
        this.table.setLinesVisible(false);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ProtectedItemsLabelProvider());
        this.tableViewer.setInput((Object)this.protectedItemWrappers);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ACIItemProtectedItemsComposite.this.protectedItemSelected();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ACIItemProtectedItemsComposite.this.protectedItemChecked();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ACIItemProtectedItemsComposite.this.editButton.isEnabled()) {
                    ACIItemProtectedItemsComposite.this.editProtectedItem();
                }
            }
        });
    }

    private void createButtonComposite() {
        GridData reverseSelectionButtonGridData = new GridData();
        reverseSelectionButtonGridData.horizontalAlignment = 4;
        reverseSelectionButtonGridData.grabExcessHorizontalSpace = false;
        reverseSelectionButtonGridData.verticalAlignment = 1;
        reverseSelectionButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData deselectAllButtonGridData = new GridData();
        deselectAllButtonGridData.horizontalAlignment = 4;
        deselectAllButtonGridData.grabExcessHorizontalSpace = false;
        deselectAllButtonGridData.verticalAlignment = 1;
        deselectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData selectAllButtonGridData = new GridData();
        selectAllButtonGridData.horizontalAlignment = 4;
        selectAllButtonGridData.grabExcessHorizontalSpace = false;
        selectAllButtonGridData.verticalAlignment = 1;
        selectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData editButtonGridData = new GridData();
        editButtonGridData.horizontalAlignment = 4;
        editButtonGridData.grabExcessHorizontalSpace = false;
        editButtonGridData.verticalAlignment = 1;
        editButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        this.buttonComposite = new Composite(this.composite, 0);
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setLayout((Layout)gridLayout);
        this.editButton = new Button(this.buttonComposite, 0);
        this.editButton.setText(Messages.getString("ACIItemProtectedItemsComposite.edit.button"));
        this.editButton.setLayoutData((Object)editButtonGridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemProtectedItemsComposite.this.editProtectedItem();
            }
        });
        this.editButton.setEnabled(false);
        this.selectAllButton = new Button(this.buttonComposite, 0);
        this.selectAllButton.setText(Messages.getString("ACIItemProtectedItemsComposite.selectAll.button"));
        this.selectAllButton.setLayoutData((Object)selectAllButtonGridData);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemProtectedItemsComposite.this.tableViewer.setCheckedElements((Object[])ACIItemProtectedItemsComposite.this.protectedItemWrappers);
                ACIItemProtectedItemsComposite.this.refreshTable();
            }
        });
        this.deselectAllButton = new Button(this.buttonComposite, 0);
        this.deselectAllButton.setText(Messages.getString("ACIItemProtectedItemsComposite.deselectAll.button"));
        this.deselectAllButton.setLayoutData((Object)deselectAllButtonGridData);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemProtectedItemsComposite.this.tableViewer.setCheckedElements((Object[])new ProtectedItem[0]);
                ACIItemProtectedItemsComposite.this.refreshTable();
            }
        });
        this.reverseSelectionButton = new Button(this.buttonComposite, 0);
        this.reverseSelectionButton.setText(Messages.getString("ACIItemProtectedItemsComposite.revers.button"));
        this.reverseSelectionButton.setLayoutData((Object)reverseSelectionButtonGridData);
        this.reverseSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<ProtectedItemWrapper> elements = new ArrayList<ProtectedItemWrapper>();
                elements.addAll(Arrays.asList(ACIItemProtectedItemsComposite.this.protectedItemWrappers));
                elements.removeAll(Arrays.asList(ACIItemProtectedItemsComposite.this.tableViewer.getCheckedElements()));
                ACIItemProtectedItemsComposite.this.tableViewer.setCheckedElements(elements.toArray());
                ACIItemProtectedItemsComposite.this.refreshTable();
            }
        });
    }

    public void setContext(ACIItemValueWithContext context) {
        this.context = context;
    }

    public void setProtectedItems(Collection<ProtectedItem> protectedItems) {
        for (ProtectedItemWrapper protectedItemWrapper : this.protectedItemWrappers) {
            this.tableViewer.setChecked((Object)protectedItemWrapper, false);
        }
        for (ProtectedItem item : protectedItems) {
            for (ProtectedItemWrapper protectedItemWrapper : this.protectedItemWrappers) {
                if (protectedItemWrapper.getClazz() != item.getClass()) continue;
                protectedItemWrapper.setProtectedItem(item);
                this.tableViewer.setChecked((Object)protectedItemWrapper, true);
            }
        }
        this.refreshTable();
    }

    public Collection<ProtectedItem> getProtectedItems() throws ParseException {
        ArrayList<ProtectedItem> protectedItems = new ArrayList<ProtectedItem>();
        for (ProtectedItemWrapper protectedItemWrapper : this.protectedItemWrappers) {
            if (!this.tableViewer.getChecked((Object)protectedItemWrapper)) continue;
            ProtectedItem protectedItem = protectedItemWrapper.getProtectedItem();
            protectedItems.add(protectedItem);
        }
        return protectedItems;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((GridData)this.getLayoutData()).heightHint = visible ? -1 : 0;
    }

    private ProtectedItemWrapper getSelectedProtectedItemWrapper() {
        Object element;
        ProtectedItemWrapper protectedItemWrapper = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof ProtectedItemWrapper) {
            protectedItemWrapper = (ProtectedItemWrapper)element;
        }
        return protectedItemWrapper;
    }

    private void protectedItemSelected() {
        ProtectedItemWrapper protectedItemWrapper = this.getSelectedProtectedItemWrapper();
        if (protectedItemWrapper == null || !protectedItemWrapper.isEditable()) {
            this.editButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
        }
    }

    private void protectedItemChecked() {
        this.refreshTable();
    }

    private void editProtectedItem() {
        ProtectedItemWrapper protectedItemWrapper = this.getSelectedProtectedItemWrapper();
        AbstractDialogStringValueEditor valueEditor = protectedItemWrapper.getValueEditor();
        if (valueEditor != null) {
            if (protectedItemWrapper.isMultivalued()) {
                MultiValuedDialog dialog = new MultiValuedDialog(this.getShell(), protectedItemWrapper.getDisplayName(), protectedItemWrapper.getValues(), this.context, valueEditor);
                dialog.open();
                this.refreshTable();
            } else {
                String oldValue;
                List<String> values = protectedItemWrapper.getValues();
                String string = oldValue = values.isEmpty() ? null : values.get(0);
                if (oldValue == null) {
                    oldValue = "";
                }
                Attribute attribute = new Attribute(this.context.getEntry(), "");
                Value value = new Value((IAttribute)attribute, (Object)oldValue);
                Object oldRawValue = valueEditor.getRawValue((IValue)value);
                CellEditor cellEditor = valueEditor.getCellEditor();
                cellEditor.setValue(oldRawValue);
                cellEditor.activate();
                Object newRawValue = cellEditor.getValue();
                if (newRawValue != null) {
                    String newValue = (String)valueEditor.getStringOrBinaryValue(newRawValue);
                    values.clear();
                    values.add(newValue);
                    this.tableViewer.refresh();
                }
            }
        }
    }

    private void refreshTable() {
        this.tableViewer.refresh();
    }

    private class ProtectedItemsLabelProvider
    extends LabelProvider {
        private ProtectedItemsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ProtectedItemWrapper) {
                ProtectedItemWrapper wrapper = (ProtectedItemWrapper)element;
                if (ACIItemProtectedItemsComposite.this.tableViewer.getChecked((Object)wrapper)) {
                    try {
                        wrapper.getProtectedItem();
                    }
                    catch (ParseException e) {
                        return Activator.getDefault().getImage(Messages.getString("ACIItemProtectedItemsComposite.error.icon"));
                    }
                }
            }
            return null;
        }
    }
}

