/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.valueeditors;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.aciitemeditor.valueeditors.SubtreeSpecificationDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.swt.widgets.Shell;

public class SubtreeValueEditor
extends AbstractDialogStringValueEditor {
    static final String EMPTY = "";
    private boolean refinementOrFilterVisible;
    private boolean useLocalName;

    public SubtreeValueEditor() {
        this.refinementOrFilterVisible = true;
        this.useLocalName = true;
    }

    public SubtreeValueEditor(boolean refinementOrFilterVisible, boolean useLocalName) {
        this.refinementOrFilterVisible = refinementOrFilterVisible;
        this.useLocalName = useLocalName;
    }

    protected boolean openDialog(Shell shell) {
        SubtreeSpecificationValueWrapper wrapper;
        SubtreeSpecificationDialog dialog;
        Object value = this.getValue();
        if (value != null && value instanceof SubtreeSpecificationValueWrapper && (dialog = new SubtreeSpecificationDialog(shell, (wrapper = (SubtreeSpecificationValueWrapper)value).connection, wrapper.subentryDN, wrapper.subtreeSpecification, this.refinementOrFilterVisible, this.useLocalName)).open() == 0 && dialog.getSubtreeSpecificationValue() != null) {
            this.setValue(dialog.getSubtreeSpecificationValue());
            return true;
        }
        return false;
    }

    public Object getRawValue(IValue value) {
        Object o = super.getRawValue(value);
        if (o != null && o instanceof String) {
            IBrowserConnection connection = value.getAttribute().getEntry().getBrowserConnection();
            LdapDN dn = value.getAttribute().getEntry().getDn();
            return new SubtreeSpecificationValueWrapper(connection, dn, value.getStringValue());
        }
        return null;
    }

    private class SubtreeSpecificationValueWrapper {
        private IBrowserConnection connection;
        private LdapDN subentryDN;
        private String subtreeSpecification;

        private SubtreeSpecificationValueWrapper(IBrowserConnection connection, LdapDN subentryDN, String subtreeSpecification) {
            this.connection = connection;
            this.subentryDN = subentryDN;
            this.subtreeSpecification = subtreeSpecification;
        }

        public String toString() {
            return this.subtreeSpecification == null ? SubtreeValueEditor.EMPTY : this.subtreeSpecification;
        }
    }
}

