/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.valueeditors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.valueeditors.Messages;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class ExclusionDialog
extends Dialog {
    private IBrowserConnection connection;
    private LdapDN base;
    private String initialType;
    private String initalDN;
    private String returnType;
    private String returnDN;
    private static final String EMPTY = "";
    private static final String CHOP_BEFORE = "chopBefore";
    private static final String CHOP_AFTER = "chopAfter";
    private Combo typeCombo;
    private ComboViewer typeComboViewer;
    private EntryWidget entryWidget;

    protected ExclusionDialog(Shell parentShell, IBrowserConnection connection, LdapDN base, String exclusion) {
        super(parentShell);
        this.connection = connection;
        this.base = base;
        try {
            Pattern pattern = Pattern.compile("\\s*(chopBefore|chopAfter):\\s*\"(.*)\"\\s*");
            Matcher matcher = pattern.matcher(exclusion);
            this.initialType = matcher.matches() ? matcher.group(1) : EMPTY;
            this.initalDN = matcher.matches() ? matcher.group(2) : EMPTY;
        }
        catch (Exception e) {
            this.initialType = EMPTY;
            this.initalDN = EMPTY;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ExclusionValueEditor.title"));
        shell.setImage(Activator.getDefault().getImage(Messages.getString("ExclusionValueEditor.icon")));
    }

    protected void okPressed() {
        this.returnType = this.typeCombo.getText();
        this.returnDN = this.entryWidget.getDn().toString();
        this.entryWidget.saveDialogSettings();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(3, false));
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ExclusionValueEditor.label.type"), (int)1);
        this.typeCombo = new Combo(composite, 8);
        String[] types = new String[]{CHOP_BEFORE, CHOP_AFTER};
        this.typeComboViewer = new ComboViewer(this.typeCombo);
        this.typeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.typeComboViewer.setInput((Object)types);
        this.typeComboViewer.setSelection((ISelection)new StructuredSelection((Object)CHOP_BEFORE), true);
        this.typeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.initialType), true);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 1;
        this.typeCombo.setLayoutData((Object)gridData);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ExclusionValueEditor.label.rdn"), (int)1);
        this.entryWidget = new EntryWidget(this.connection, null, this.base, true);
        this.entryWidget.createWidget(composite);
        try {
            LdapDN dn = new LdapDN(this.initalDN);
            this.entryWidget.setInput(this.connection, dn, this.base, true);
        }
        catch (InvalidNameException e) {
            // empty catch block
        }
        this.entryWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ExclusionDialog.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    private void validate() {
        boolean valid;
        boolean bl = valid = this.entryWidget.getDn() != null && this.entryWidget.getDn().size() > 0;
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(valid);
        }
    }

    public String getType() {
        return this.returnType;
    }

    public String getDN() {
        return this.returnDN;
    }
}

