/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.sourceeditor;

import java.util.ArrayList;
import org.apache.directory.studio.aciitemeditor.sourceeditor.ACITextAttributeProvider;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class ACICodeScanner
extends RuleBasedScanner {
    public static final String identificationTagPartition = "identificationTag";
    public static final String precedencePartition = "precedence";
    public static final String authenticationLevelPartition = "authenticationLevel";
    public static final String[] itemOrUserFirstSectionPartition = new String[]{"itemOrUserFirst", "itemFirst", "userFirst"};
    public static final String[] userSection = new String[]{"userClasses", "userPermissions"};
    public static final String[] aciKeywords = new String[]{"protectedItems", "itemPermissions", "entry", "allUserAttributeTypes", "attributeType", "allAttributeValues", "allUserAttributeTypesAndValues", "attributeValue", "selfValue", "rangeOfValues", "maxValueCount", "maxImmSub", "restrictedBy", "classes", "grantsAndDenials", "allUsers", "thisEntry", "name", "userGroup", "subtree", "type", "valuesIn", "none", "simple", "strong"};
    public static final String[] aciGrantValues = new String[]{"grantAdd", "grantDiscloseOnError", "grantRead", "grantRemove", "grantBrowse", "grantExport", "grantImport", "grantModify", "grantRename", "grantReturnDN", "grantCompare", "grantFilterMatch", "grantInvoke"};
    public static final String[] aciDenyValues = new String[]{"denyAdd", "denyDiscloseOnError", "denyRead", "denyRemove", "denyBrowse", "denyExport", "denyImport", "denyModify", "denyRename", "denyReturnDN", "denyCompare", "denyFilterMatch", "denyInvoke"};

    public ACICodeScanner(ACITextAttributeProvider provider) {
        int i;
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = new Token((Object)provider.getAttribute("__pos_aci_keyword_attribute"));
        Token undefined = new Token((Object)provider.getAttribute("__pos_aci_default_attribute"));
        Token string = new Token((Object)provider.getAttribute("__pos_aci_string_attribute"));
        Token grantValue = new Token((Object)provider.getAttribute("__pos_aci_grant_value"));
        Token denyValue = new Token((Object)provider.getAttribute("__pos_aci_deny_value"));
        Token identification = new Token((Object)provider.getAttribute("__pos_aci_identification_attribute"));
        Token precedence = new Token((Object)provider.getAttribute("__pos_aci_precedence_attribute"));
        Token authenticationLevel = new Token((Object)provider.getAttribute("__pos_aci_authenticationlevel_attribute"));
        Token itemOrUserFirst = new Token((Object)provider.getAttribute("__pos_aci_itemoruserfirst_attribute"));
        Token user = new Token((Object)provider.getAttribute("__pos_aci_user_attribute"));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\u0000', true));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\u0000', true));
        rules.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }));
        WordRule wr = new WordRule((IWordDetector)new AciWordDetector(), (IToken)undefined);
        for (i = 0; i < aciKeywords.length; ++i) {
            wr.addWord(aciKeywords[i], (IToken)keyword);
        }
        for (i = 0; i < aciGrantValues.length; ++i) {
            wr.addWord(aciGrantValues[i], (IToken)grantValue);
        }
        for (i = 0; i < aciDenyValues.length; ++i) {
            wr.addWord(aciDenyValues[i], (IToken)denyValue);
        }
        for (i = 0; i < itemOrUserFirstSectionPartition.length; ++i) {
            wr.addWord(itemOrUserFirstSectionPartition[i], (IToken)itemOrUserFirst);
        }
        for (i = 0; i < userSection.length; ++i) {
            wr.addWord(userSection[i], (IToken)user);
        }
        wr.addWord(identificationTagPartition, (IToken)identification);
        wr.addWord(precedencePartition, (IToken)precedence);
        wr.addWord(authenticationLevelPartition, (IToken)authenticationLevel);
        rules.add(wr);
        IRule[] param = new IRule[rules.size()];
        rules.toArray(param);
        this.setRules(param);
    }

    static class AciWordDetector
    implements IWordDetector {
        AciWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#' || c == '@' || c == '~' || c == '.' || c == '?';
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c) || c == '.' || c == '_' || c == '?' || c == '$';
        }
    }
}

