/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.aci.UserFirstACIItem;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.studio.aciitemeditor.model.Messages;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserClassWrapper {
    public static final Map<Class<? extends UserClass>, String> classToIdentifierMap;
    public static final Map<Class<? extends UserClass>, String> classToDisplayMap;
    private static final String DUMMY = "{ identificationTag \"id1\", precedence 1, authenticationLevel simple, itemOrUserFirst userFirst: { userClasses  { #identifier# #values# }, userPermissions { { protectedItems { entry }, grantsAndDenials { grantRead } } } } }";
    private final Class<? extends UserClass> clazz;
    private List<String> values;
    private String valuePrefix;
    private String valueSuffix;
    private AbstractDialogStringValueEditor valueEditor;

    public UserClassWrapper(Class<? extends UserClass> clazz, String valuePrefix, String valueSuffix, AbstractDialogStringValueEditor valueEditor) {
        this.clazz = clazz;
        this.valuePrefix = valuePrefix;
        this.valueSuffix = valueSuffix;
        this.valueEditor = valueEditor;
        this.values = new ArrayList<String>();
    }

    public UserClass getUserClass() throws ParseException {
        String flatValue = this.getFlatValue();
        String spec = DUMMY;
        spec = spec.replaceAll("#identifier#", this.getIdentifier());
        spec = spec.replaceAll("#values#", flatValue);
        ACIItemParser parser = new ACIItemParser(null);
        UserFirstACIItem aci = null;
        try {
            aci = (UserFirstACIItem)parser.parse(spec);
        }
        catch (ParseException e) {
            String msg = NLS.bind((String)Messages.getString("UserClassWrapper.error.message"), (Object[])new String[]{this.getIdentifier(), flatValue});
            throw new ParseException(msg, 0);
        }
        UserClass userClass = (UserClass)aci.getUserClasses().iterator().next();
        return userClass;
    }

    public void setUserClass(UserClass userClass) {
        block5: {
            block6: {
                block4: {
                    assert (userClass.getClass() == this.getClazz());
                    this.values.clear();
                    if (userClass.getClass() != UserClass.Name.class) break block4;
                    UserClass.Name name = (UserClass.Name)userClass;
                    Set jndiNames = name.getNames();
                    for (LdapDN jndiName : jndiNames) {
                        this.values.add(jndiName.toString());
                    }
                    break block5;
                }
                if (userClass.getClass() != UserClass.UserGroup.class) break block6;
                UserClass.UserGroup userGrops = (UserClass.UserGroup)userClass;
                Set jndiNames = userGrops.getNames();
                for (LdapDN jndiName : jndiNames) {
                    this.values.add(jndiName.toString());
                }
                break block5;
            }
            if (userClass.getClass() != UserClass.Subtree.class) break block5;
            UserClass.Subtree subtree = (UserClass.Subtree)userClass;
            Collection subtreeSpecifications = subtree.getSubtreeSpecifications();
            for (SubtreeSpecification subtreeSpecification : subtreeSpecifications) {
                StringBuilder buffer = new StringBuilder();
                subtreeSpecification.printToBuffer(buffer);
                String s = buffer.toString();
                this.values.add(s);
            }
        }
    }

    public String toString() {
        String flatValue = this.getFlatValue();
        if (flatValue.length() > 0) {
            flatValue = flatValue.replace('\r', ' ');
            flatValue = flatValue.replace('\n', ' ');
            flatValue = ": " + flatValue;
            if (flatValue.length() > 40) {
                String temp = flatValue;
                flatValue = temp.substring(0, 20);
                flatValue = flatValue + "...";
                flatValue = flatValue + temp.substring(temp.length() - 20, temp.length());
            }
        }
        return this.getDisplayName() + " " + flatValue;
    }

    private String getFlatValue() {
        if (this.valueEditor == null || this.values.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        Iterator<String> it = this.values.iterator();
        while (it.hasNext()) {
            sb.append(this.valuePrefix);
            String value = it.next();
            sb.append(value);
            sb.append(this.valueSuffix);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" }");
        return sb.toString();
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getDisplayName() {
        return classToDisplayMap.get(this.clazz);
    }

    public String getIdentifier() {
        return classToIdentifierMap.get(this.clazz);
    }

    public Class<? extends UserClass> getClazz() {
        return this.clazz;
    }

    public boolean isEditable() {
        return this.valueEditor != null;
    }

    public AbstractDialogStringValueEditor getValueEditor() {
        return this.valueEditor;
    }

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(UserClass.AllUsers.class, "allUsers");
        map.put(UserClass.ThisEntry.class, "thisEntry");
        map.put(UserClass.ParentOfEntry.class, "parentOfEntry");
        map.put(UserClass.Name.class, "name");
        map.put(UserClass.UserGroup.class, "userGroup");
        map.put(UserClass.Subtree.class, "subtree");
        classToIdentifierMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(UserClass.AllUsers.class, Messages.getString("UserClassWrapper.userClass.allUsers.label"));
        map.put(UserClass.ThisEntry.class, Messages.getString("UserClassWrapper.userClass.thisEntry.label"));
        map.put(UserClass.ParentOfEntry.class, Messages.getString("UserClassWrapper.userClass.parentOfEntry.label"));
        map.put(UserClass.Name.class, Messages.getString("UserClassWrapper.userClass.name.label"));
        map.put(UserClass.UserGroup.class, Messages.getString("UserClassWrapper.userClass.userGroup.label"));
        map.put(UserClass.Subtree.class, Messages.getString("UserClassWrapper.userClass.subtree.label"));
        classToDisplayMap = Collections.unmodifiableMap(map);
    }
}

