/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ItemFirstACIItem;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.studio.aciitemeditor.model.Messages;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedItemWrapper {
    public static final Map<Class<? extends ProtectedItem>, String> classToIdentifierMap;
    public static final Map<Class<? extends ProtectedItem>, String> classToDisplayMap;
    private static final String DUMMY = "{ identificationTag \"id1\", precedence 1, authenticationLevel simple, itemOrUserFirst itemFirst: { protectedItems  { #identifier# #values# }, itemPermissions { { userClasses { allUsers }, grantsAndDenials { grantRead } } } } }";
    private final Class<? extends ProtectedItem> clazz;
    private List<String> values;
    private String valuePrefix;
    private String valueSuffix;
    private AbstractDialogStringValueEditor valueEditor;
    private boolean isMultivalued;

    public ProtectedItemWrapper(Class<? extends ProtectedItem> clazz, boolean isMultivalued, String valuePrefix, String valueSuffix, AbstractDialogStringValueEditor valueEditor) {
        this.clazz = clazz;
        this.isMultivalued = isMultivalued;
        this.valuePrefix = valuePrefix;
        this.valueSuffix = valueSuffix;
        this.valueEditor = valueEditor;
        this.values = new ArrayList<String>();
    }

    public ProtectedItem getProtectedItem() throws ParseException {
        String flatValue = this.getFlatValue();
        String spec = DUMMY;
        spec = spec.replaceAll("#identifier#", this.getIdentifier());
        spec = spec.replaceAll("#values#", flatValue);
        ACIItemParser parser = new ACIItemParser(null);
        ItemFirstACIItem aci = null;
        try {
            aci = (ItemFirstACIItem)parser.parse(spec);
        }
        catch (ParseException e) {
            String msg = NLS.bind((String)Messages.getString("ProtectedItemWrapper.error.message"), (Object[])new String[]{this.getIdentifier(), flatValue});
            throw new ParseException(msg, 0);
        }
        ProtectedItem item = (ProtectedItem)aci.getProtectedItems().iterator().next();
        return item;
    }

    public void setProtectedItem(ProtectedItem item) {
        assert (item.getClass() == this.getClazz());
        this.values.clear();
        if (item.getClass() == ProtectedItem.AttributeType.class) {
            ProtectedItem.AttributeType at = (ProtectedItem.AttributeType)item;
            Iterator it = at.iterator();
            while (it.hasNext()) {
                this.values.add((String)it.next());
            }
        } else if (item.getClass() == ProtectedItem.AllAttributeValues.class) {
            ProtectedItem.AllAttributeValues aav = (ProtectedItem.AllAttributeValues)item;
            Iterator it = aav.iterator();
            while (it.hasNext()) {
                this.values.add((String)it.next());
            }
        } else if (item.getClass() == ProtectedItem.AttributeValue.class) {
            ProtectedItem.AttributeValue av = (ProtectedItem.AttributeValue)item;
            for (Attribute attribute : av) {
                try {
                    this.values.add(attribute.getID() + "=" + attribute.get());
                }
                catch (NamingException e) {}
            }
        } else if (item.getClass() == ProtectedItem.SelfValue.class) {
            ProtectedItem.SelfValue sv = (ProtectedItem.SelfValue)item;
            Iterator it = sv.iterator();
            while (it.hasNext()) {
                this.values.add((String)it.next());
            }
        } else if (item.getClass() == ProtectedItem.RangeOfValues.class) {
            ProtectedItem.RangeOfValues rov = (ProtectedItem.RangeOfValues)item;
            this.values.add(rov.getFilter().toString());
        } else if (item.getClass() == ProtectedItem.MaxValueCount.class) {
            ProtectedItem.MaxValueCount mvc = (ProtectedItem.MaxValueCount)item;
            for (ProtectedItem.MaxValueCountItem mvci : mvc) {
                this.values.add(mvci.toString());
            }
        } else if (item.getClass() == ProtectedItem.MaxImmSub.class) {
            ProtectedItem.MaxImmSub mis = (ProtectedItem.MaxImmSub)item;
            this.values.add(Integer.toString(mis.getValue()));
        } else if (item.getClass() == ProtectedItem.RestrictedBy.class) {
            ProtectedItem.RestrictedBy rb = (ProtectedItem.RestrictedBy)item;
            for (ProtectedItem.RestrictedByItem rbi : rb) {
                this.values.add(rbi.toString());
            }
        } else if (item.getClass() == ProtectedItem.Classes.class) {
            ProtectedItem.Classes classes = (ProtectedItem.Classes)item;
            StringBuilder sb = new StringBuilder();
            classes.getClasses().printRefinementToBuffer(sb);
            this.values.add(sb.toString());
        }
    }

    public String toString() {
        String flatValue = this.getFlatValue();
        if (flatValue.length() > 0) {
            flatValue = flatValue.replace('\r', ' ');
            flatValue = flatValue.replace('\n', ' ');
            flatValue = ": " + flatValue;
            if (flatValue.length() > 40) {
                String temp = flatValue;
                flatValue = temp.substring(0, 20);
                flatValue = flatValue + "...";
                flatValue = flatValue + temp.substring(temp.length() - 20, temp.length());
            }
        }
        return this.getDisplayName() + " " + flatValue;
    }

    private String getFlatValue() {
        if (this.valueEditor == null || this.values.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.isMultivalued()) {
            sb.append("{ ");
        }
        Iterator<String> it = this.values.iterator();
        while (it.hasNext()) {
            sb.append(this.valuePrefix);
            String value = it.next();
            sb.append(value);
            sb.append(this.valueSuffix);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        if (this.isMultivalued()) {
            sb.append(" }");
        }
        return sb.toString();
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getDisplayName() {
        return classToDisplayMap.get(this.clazz);
    }

    public String getIdentifier() {
        return classToIdentifierMap.get(this.clazz);
    }

    public Class<? extends ProtectedItem> getClazz() {
        return this.clazz;
    }

    public boolean isEditable() {
        return this.valueEditor != null;
    }

    public AbstractDialogStringValueEditor getValueEditor() {
        return this.valueEditor;
    }

    public boolean isMultivalued() {
        return this.isMultivalued;
    }

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(ProtectedItem.Entry.class, "entry");
        map.put(ProtectedItem.AllUserAttributeTypes.class, "allUserAttributeTypes");
        map.put(ProtectedItem.AttributeType.class, "attributeType");
        map.put(ProtectedItem.AllAttributeValues.class, "allAttributeValues");
        map.put(ProtectedItem.AllUserAttributeTypesAndValues.class, "allUserAttributeTypesAndValues");
        map.put(ProtectedItem.AttributeValue.class, "attributeValue");
        map.put(ProtectedItem.SelfValue.class, "selfValue");
        map.put(ProtectedItem.RangeOfValues.class, "rangeOfValues");
        map.put(ProtectedItem.MaxValueCount.class, "maxValueCount");
        map.put(ProtectedItem.MaxImmSub.class, "maxImmSub");
        map.put(ProtectedItem.RestrictedBy.class, "restrictedBy");
        map.put(ProtectedItem.Classes.class, "classes");
        classToIdentifierMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(ProtectedItem.Entry.class, Messages.getString("ProtectedItemWrapper.protectedItem.entry.label"));
        map.put(ProtectedItem.AllUserAttributeTypes.class, Messages.getString("ProtectedItemWrapper.protectedItem.allUserAttributeTypes.label"));
        map.put(ProtectedItem.AttributeType.class, Messages.getString("ProtectedItemWrapper.protectedItem.attributeType.label"));
        map.put(ProtectedItem.AllAttributeValues.class, Messages.getString("ProtectedItemWrapper.protectedItem.allAttributeValues.label"));
        map.put(ProtectedItem.AllUserAttributeTypesAndValues.class, Messages.getString("ProtectedItemWrapper.protectedItem.allUserAttributeTypesAndValues.label"));
        map.put(ProtectedItem.AttributeValue.class, Messages.getString("ProtectedItemWrapper.protectedItem.attributeValue.label"));
        map.put(ProtectedItem.SelfValue.class, Messages.getString("ProtectedItemWrapper.protectedItem.selfValue.label"));
        map.put(ProtectedItem.RangeOfValues.class, Messages.getString("ProtectedItemWrapper.protectedItem.rangeOfValues.label"));
        map.put(ProtectedItem.MaxValueCount.class, Messages.getString("ProtectedItemWrapper.protectedItem.maxValueCount.label"));
        map.put(ProtectedItem.MaxImmSub.class, Messages.getString("ProtectedItemWrapper.protectedItem.maxImmSub.label"));
        map.put(ProtectedItem.RestrictedBy.class, Messages.getString("ProtectedItemWrapper.protectedItem.restrictedBy.label"));
        map.put(ProtectedItem.Classes.class, Messages.getString("ProtectedItemWrapper.protectedItem.classes.label"));
        classToDisplayMap = Collections.unmodifiableMap(map);
    }
}

