/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.dialogs;

import java.util.List;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValuedDialog
extends Dialog {
    private String displayName;
    private AbstractDialogStringValueEditor valueEditor;
    private List<String> values;
    private ACIItemValueWithContext context;
    private Composite composite = null;
    private Table table = null;
    private TableViewer tableViewer = null;
    private Composite buttonComposite = null;
    private Button addButton = null;
    private Button editButton = null;
    private Button deleteButton = null;

    public MultiValuedDialog(Shell parentShell, String displayName, List<String> values, ACIItemValueWithContext context, AbstractDialogStringValueEditor valueEditor) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.displayName = displayName;
        this.values = values;
        this.context = context;
        this.valueEditor = valueEditor;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("MultiValuedDialog.dialog.titlePrefix") + this.displayName);
        shell.setImage(Activator.getDefault().getImage(Messages.getString("MultiValuedDialog.dialog.icon")));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        this.composite.setLayoutData((Object)gd);
        GridLayout layout = (GridLayout)this.composite.getLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        this.createTable();
        this.createButtonComposite();
        MultiValuedDialog.applyDialogFont((Control)this.composite);
        return this.composite;
    }

    private void createTable() {
        GridData tableGridData = new GridData(1808);
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        this.table = new Table(this.composite, 2048);
        this.table.setHeaderVisible(false);
        this.table.setLayoutData((Object)tableGridData);
        this.table.setLinesVisible(false);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setInput(this.values);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MultiValuedDialog.this.valueSelected();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MultiValuedDialog.this.editValue();
            }
        });
    }

    private void createButtonComposite() {
        GridData deleteButtonGridData = new GridData();
        deleteButtonGridData.horizontalAlignment = 4;
        deleteButtonGridData.grabExcessHorizontalSpace = false;
        deleteButtonGridData.verticalAlignment = 1;
        deleteButtonGridData.widthHint = Activator.getButtonWidth((Control)this.composite);
        GridData editButtonGridData = new GridData();
        editButtonGridData.horizontalAlignment = 4;
        editButtonGridData.grabExcessHorizontalSpace = false;
        editButtonGridData.verticalAlignment = 1;
        editButtonGridData.widthHint = Activator.getButtonWidth((Control)this.composite);
        GridData addButtonGridData = new GridData();
        addButtonGridData.horizontalAlignment = 4;
        addButtonGridData.grabExcessHorizontalSpace = false;
        addButtonGridData.verticalAlignment = 1;
        addButtonGridData.widthHint = Activator.getButtonWidth((Control)this.composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        this.buttonComposite = new Composite(this.composite, 0);
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setLayout((Layout)gridLayout);
        this.addButton = new Button(this.buttonComposite, 0);
        this.addButton.setText(Messages.getString("MultiValuedDialog.button.add"));
        this.addButton.setLayoutData((Object)addButtonGridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValuedDialog.this.addValue();
            }
        });
        this.editButton = new Button(this.buttonComposite, 0);
        this.editButton.setText(Messages.getString("MultiValuedDialog.button.edit"));
        this.editButton.setLayoutData((Object)editButtonGridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValuedDialog.this.editValue();
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(this.buttonComposite, 0);
        this.deleteButton.setText(Messages.getString("MultiValuedDialog.button.delete"));
        this.deleteButton.setLayoutData((Object)deleteButtonGridData);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValuedDialog.this.deleteValue();
            }
        });
        this.deleteButton.setEnabled(false);
    }

    private void addValue() {
        Attribute attribute = new Attribute(this.context.getEntry(), "");
        Value value = new Value((IAttribute)attribute, (Object)"");
        Object oldRawValue = this.valueEditor.getRawValue((IValue)value);
        CellEditor cellEditor = this.valueEditor.getCellEditor();
        cellEditor.setValue(oldRawValue);
        cellEditor.activate();
        Object newRawValue = cellEditor.getValue();
        if (newRawValue != null) {
            String newValue = (String)this.valueEditor.getStringOrBinaryValue(newRawValue);
            this.values.add(newValue);
            this.tableViewer.refresh();
        }
    }

    private void editValue() {
        String oldValue = this.getSelectedValue();
        if (oldValue != null) {
            Attribute attribute = new Attribute(this.context.getEntry(), "");
            Value value = new Value((IAttribute)attribute, (Object)oldValue);
            Object oldRawValue = this.valueEditor.getRawValue((IValue)value);
            CellEditor cellEditor = this.valueEditor.getCellEditor();
            cellEditor.setValue(oldRawValue);
            cellEditor.activate();
            Object newRawValue = cellEditor.getValue();
            if (newRawValue != null) {
                String newValue = (String)this.valueEditor.getStringOrBinaryValue(newRawValue);
                this.values.remove(oldValue);
                this.values.add(newValue);
                this.tableViewer.refresh();
            }
        }
    }

    private void deleteValue() {
        String value = this.getSelectedValue();
        if (value != null) {
            this.values.remove(value);
            this.tableViewer.refresh();
        }
    }

    private void valueSelected() {
        String value = this.getSelectedValue();
        if (value == null) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private String getSelectedValue() {
        Object element;
        String value = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof String) {
            value = (String)element;
        }
        return value;
    }
}

