/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.dialogs;

import java.text.ParseException;
import org.apache.directory.studio.aciitemeditor.ACIITemConstants;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.Messages;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemTabFolderComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ACIItemDialog
extends Dialog {
    private ACIItemValueWithContext context;
    private String returnValue;
    private ACIItemTabFolderComposite tabFolderComposite;

    public ACIItemDialog(Shell parentShell, ACIItemValueWithContext context) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        assert (context != null);
        assert (context.getACIItemValue() != null);
        assert (context.getConnection() != null);
        this.context = context;
        this.returnValue = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ACIItemDialog.dialog.text"));
        shell.setImage(Activator.getDefault().getImage(Messages.getString("ACIItemDialog.dialog.icon")));
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        super.createButton(composite, 987654321, Messages.getString("ACIItemDialog.button.format"), false);
        super.createButton(composite, 876543210, Messages.getString("ACIItemDialog.button.checkSyntax"), false);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 987654321) {
            this.tabFolderComposite.format();
        }
        if (buttonId == 876543210) {
            try {
                this.tabFolderComposite.getInput();
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("ACIItemDialog.syntaxOk.title"), (String)Messages.getString("ACIItemDialog.syntaxOk.text"));
            }
            catch (ParseException pe) {
                Status status = new Status(4, ACIITemConstants.PLUGIN_ID, 1, Messages.getString("ACIItemDialog.error.invalidSyntax"), (Throwable)pe);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("ACIItemDialog.error.title"), null, (IStatus)status);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        try {
            this.returnValue = this.tabFolderComposite.getInput();
            super.okPressed();
        }
        catch (ParseException pe) {
            Status status = new Status(4, ACIITemConstants.PLUGIN_ID, 1, Messages.getString("ACIItemDialog.error.invalidSyntax"), (Throwable)pe);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("ACIItemDialog.error.title"), null, (IStatus)status);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300) * 4 / 3;
        gd.heightHint = this.convertVerticalDLUsToPixels(300) * 4 / 3;
        composite.setLayoutData((Object)gd);
        this.tabFolderComposite = new ACIItemTabFolderComposite(composite, 0);
        if (this.context != null) {
            this.tabFolderComposite.setContext(this.context);
            this.tabFolderComposite.setInput(this.context.getACIItemValue());
        }
        ACIItemDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getACIItemValue() {
        return this.returnValue;
    }
}

