/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor;

import java.io.IOException;
import java.util.PropertyResourceBundle;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.studio.aciitemeditor.ACIITemConstants;
import org.apache.directory.studio.aciitemeditor.sourceeditor.ACICodeScanner;
import org.apache.directory.studio.aciitemeditor.sourceeditor.ACITextAttributeProvider;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private ACIItemParser aciItemParser;
    private ACICodeScanner aciCodeScanner;
    private ACITextAttributeProvider textAttributeProvider;
    private ContributionTemplateStore aciTemplateStore;
    private ContributionContextTypeRegistry aciTemplateContextTypeRegistry;
    private PropertyResourceBundle properties;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.aciTemplateContextTypeRegistry == null) {
            this.aciTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            this.aciTemplateContextTypeRegistry.addContextType(ACIITemConstants.ACI_ITEM_TEMPLATE_ID);
            this.aciTemplateContextTypeRegistry.getContextType(ACIITemConstants.ACI_ITEM_TEMPLATE_ID).addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        }
        if (this.aciTemplateStore == null) {
            this.aciTemplateStore = new ContributionTemplateStore((ContextTypeRegistry)this.getAciTemplateContextTypeRegistry(), this.getPreferenceStore(), "templates");
            try {
                this.aciTemplateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)ACIITemConstants.PLUGIN_ID, (String)path);
    }

    public Image getImage(String path) {
        ImageDescriptor id;
        Image image = this.getImageRegistry().get(path);
        if (image == null && (id = Activator.getImageDescriptor(path)) != null) {
            image = id.createImage();
            this.getImageRegistry().put(path, image);
        }
        return image;
    }

    public ACIItemParser getACIItemParser() {
        if (this.aciItemParser == null) {
            this.aciItemParser = new ACIItemParser(null);
        }
        return this.aciItemParser;
    }

    public static int getButtonWidth(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int width = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return width;
    }

    public ACITextAttributeProvider getTextAttributeProvider() {
        if (this.textAttributeProvider == null) {
            this.textAttributeProvider = new ACITextAttributeProvider();
        }
        return this.textAttributeProvider;
    }

    public ACICodeScanner getAciCodeScanner() {
        if (this.aciCodeScanner == null) {
            this.aciCodeScanner = new ACICodeScanner(this.getTextAttributeProvider());
        }
        return this.aciCodeScanner;
    }

    public ContributionContextTypeRegistry getAciTemplateContextTypeRegistry() {
        return this.aciTemplateContextTypeRegistry;
    }

    public ContributionTemplateStore getAciTemplateStore() {
        return this.aciTemplateStore;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.aciitemeditor", 0, "Unable to get the plugin properties.", (Throwable)e));
            }
        }
        return this.properties;
    }
}

