/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wrappers;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.wrappers.AbstractTreeNode;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;

public class ProjectsViewRoot
extends AbstractTreeNode {
    private TableViewer viewer;
    private ProjectsHandler projectsHandler;

    public ProjectsViewRoot(TableViewer tableViewer) {
        super(null);
        this.viewer = tableViewer;
        this.projectsHandler = Activator.getDefault().getProjectsHandler();
        this.projectsHandler.addListener(new ProjectsHandlerListener(){

            public void projectAdded(Project project) {
                ProjectsViewRoot.this.addProjectWrapper(project);
                ProjectsViewRoot.this.refreshProjectsViewer();
            }

            public void projectRemoved(Project project) {
                ProjectsViewRoot.this.deleteProjectWrapper(project);
                ProjectsViewRoot.this.refreshProjectsViewer();
            }

            public void openProjectChanged(Project oldProject, Project newProject) {
                ProjectsViewRoot.this.refreshProjectsViewer();
            }
        });
    }

    private void addProjectWrapper(Project project) {
        this.addChild(new ProjectWrapper(project, this.viewer));
    }

    private void deleteProjectWrapper(Project project) {
        for (TreeNode node : this.getChildren()) {
            ProjectWrapper pw = (ProjectWrapper)node;
            if (project != pw.getProject()) continue;
            this.removeChild(node);
            return;
        }
    }

    public void refreshProjectsViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ProjectsViewRoot.this.viewer.refresh();
            }
        });
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectsViewRoot) {
            return this == obj;
        }
        return false;
    }
}

