/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wrappers;

import java.util.Comparator;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstNameSorter
implements Comparator<TreeNode> {
    @Override
    public int compare(TreeNode o1, TreeNode o2) {
        String[] o1Names = null;
        String[] o2Names = null;
        if (o1 instanceof AttributeTypeWrapper && o2 instanceof AttributeTypeWrapper) {
            AttributeTypeImpl at1 = ((AttributeTypeWrapper)o1).getAttributeType();
            AttributeTypeImpl at2 = ((AttributeTypeWrapper)o2).getAttributeType();
            o1Names = at1.getNamesRef();
            o2Names = at2.getNamesRef();
        } else if (o1 instanceof ObjectClassWrapper && o2 instanceof ObjectClassWrapper) {
            ObjectClassImpl oc1 = ((ObjectClassWrapper)o1).getObjectClass();
            ObjectClassImpl oc2 = ((ObjectClassWrapper)o2).getObjectClass();
            o1Names = oc1.getNamesRef();
            o2Names = oc2.getNamesRef();
        } else if (o1 instanceof AttributeTypeWrapper && o2 instanceof ObjectClassWrapper) {
            AttributeTypeImpl at = ((AttributeTypeWrapper)o1).getAttributeType();
            ObjectClassImpl oc = ((ObjectClassWrapper)o2).getObjectClass();
            o1Names = at.getNamesRef();
            o2Names = oc.getNamesRef();
        } else if (o1 instanceof ObjectClassWrapper && o2 instanceof AttributeTypeWrapper) {
            ObjectClassImpl oc = ((ObjectClassWrapper)o1).getObjectClass();
            AttributeTypeImpl at = ((AttributeTypeWrapper)o2).getAttributeType();
            o1Names = oc.getNamesRef();
            o2Names = at.getNamesRef();
        }
        if (o1Names != null && o2Names != null) {
            if (o1Names.length > 0 && o2Names.length > 0) {
                return o1Names[0].compareToIgnoreCase(o2Names[0]);
            }
            if (o1Names.length == 0 && o2Names.length > 0) {
                return "".compareToIgnoreCase(o2Names[0]);
            }
            if (o1Names.length > 0 && o2Names.length == 0) {
                return o1Names[0].compareToIgnoreCase("");
            }
        }
        return o1.toString().compareToIgnoreCase(o2.toString());
    }
}

