/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode
implements TreeNode {
    protected List<TreeNode> fChildren;
    protected TreeNode fParent;

    public AbstractTreeNode(TreeNode parent) {
        this.fParent = parent;
    }

    @Override
    public boolean hasChildren() {
        if (this.fChildren == null) {
            return false;
        }
        return !this.fChildren.isEmpty();
    }

    @Override
    public TreeNode getParent() {
        return this.fParent;
    }

    @Override
    public void setParent(TreeNode parent) {
        this.fParent = parent;
    }

    @Override
    public List<TreeNode> getChildren() {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<TreeNode>();
        }
        return this.fChildren;
    }

    @Override
    public void addChild(TreeNode node) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<TreeNode>();
        }
        if (!this.fChildren.contains(node)) {
            this.fChildren.add(node);
        }
    }

    @Override
    public void removeChild(TreeNode node) {
        if (this.fChildren != null) {
            this.fChildren.remove(node);
        }
    }

    @Override
    public boolean addAllChildren(Collection<? extends TreeNode> c) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<TreeNode>();
        }
        return this.fChildren.addAll(c);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractTreeNode) {
            AbstractTreeNode atn = (AbstractTreeNode)obj;
            return this.fParent == null || this.fParent.equals(atn.getParent());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.fParent != null) {
            result = 37 * result + this.fParent.hashCode();
        }
        return result;
    }
}

