/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewObjectClassOptionalAttributesPage
extends WizardPage {
    private List<AttributeTypeImpl> optionalAttributeTypesList;
    private TableViewer optionalAttributeTypesTableViewer;
    private Button optionalAttributeTypesAddButton;
    private Button optionalAttributeTypesRemoveButton;

    protected NewObjectClassOptionalAttributesPage() {
        super("NewObjectClassOptionalAttributesPage");
        this.setTitle(Messages.getString("NewObjectClassOptionalAttributesPage.OptionalAttributeTypes"));
        this.setDescription(Messages.getString("NewObjectClassOptionalAttributesPage.SpecifiyOptionalAttributeTypesForObjectClass"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/object_class_new_wizard.png"));
        this.optionalAttributeTypesList = new ArrayList<AttributeTypeImpl>();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group optionalAttributeTypesGroup = new Group(composite, 0);
        optionalAttributeTypesGroup.setText(Messages.getString("NewObjectClassOptionalAttributesPage.OptionalAttributeTypes"));
        optionalAttributeTypesGroup.setLayout((Layout)new GridLayout(2, false));
        optionalAttributeTypesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Table optionalAttributeTypesTable = new Table((Composite)optionalAttributeTypesGroup, 2048);
        GridData optionalAttributeTypesTableGridData = new GridData(4, 4, true, true, 1, 2);
        optionalAttributeTypesTableGridData.heightHint = 100;
        optionalAttributeTypesTable.setLayoutData((Object)optionalAttributeTypesTableGridData);
        this.optionalAttributeTypesTableViewer = new TableViewer(optionalAttributeTypesTable);
        this.optionalAttributeTypesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.optionalAttributeTypesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof AttributeTypeImpl) {
                    return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof AttributeTypeImpl) {
                    AttributeTypeImpl at = (AttributeTypeImpl)((Object)element);
                    String[] names = at.getNamesRef();
                    if (names != null && names.length > 0) {
                        return NLS.bind((String)Messages.getString("NewObjectClassOptionalAttributesPage.AliasOID"), (Object[])new String[]{ViewUtils.concateAliases(names), at.getOid()});
                    }
                    return NLS.bind((String)Messages.getString("NewObjectClassOptionalAttributesPage.NoneOID"), (Object[])new String[]{at.getOid()});
                }
                return super.getText(element);
            }
        });
        this.optionalAttributeTypesTableViewer.setInput(this.optionalAttributeTypesList);
        this.optionalAttributeTypesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewObjectClassOptionalAttributesPage.this.optionalAttributeTypesRemoveButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.optionalAttributeTypesAddButton = new Button((Composite)optionalAttributeTypesGroup, 8);
        this.optionalAttributeTypesAddButton.setText(Messages.getString("NewObjectClassOptionalAttributesPage.Add"));
        this.optionalAttributeTypesAddButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.optionalAttributeTypesAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassOptionalAttributesPage.this.addOptionalAttributeType();
            }
        });
        this.optionalAttributeTypesRemoveButton = new Button((Composite)optionalAttributeTypesGroup, 8);
        this.optionalAttributeTypesRemoveButton.setText(Messages.getString("NewObjectClassOptionalAttributesPage.Remove"));
        this.optionalAttributeTypesRemoveButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.optionalAttributeTypesRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassOptionalAttributesPage.this.removeOptionalAttributeType();
            }
        });
        this.optionalAttributeTypesRemoveButton.setEnabled(false);
        this.setControl((Control)composite);
    }

    private void addOptionalAttributeType() {
        AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
        ArrayList<AttributeTypeImpl> hiddenAttributes = new ArrayList<AttributeTypeImpl>();
        hiddenAttributes.addAll(this.optionalAttributeTypesList);
        dialog.setHiddenAttributeTypes(hiddenAttributes);
        if (dialog.open() == 0) {
            this.optionalAttributeTypesList.add(dialog.getSelectedAttributeType());
            this.updateOptionalAttributeTypesTableTable();
        }
    }

    private void removeOptionalAttributeType() {
        StructuredSelection selection = (StructuredSelection)this.optionalAttributeTypesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.optionalAttributeTypesList.remove(selection.getFirstElement());
            this.updateOptionalAttributeTypesTableTable();
        }
    }

    private void updateOptionalAttributeTypesTableTable() {
        Collections.sort(this.optionalAttributeTypesList, new Comparator<AttributeTypeImpl>(){

            @Override
            public int compare(AttributeTypeImpl o1, AttributeTypeImpl o2) {
                String[] at1Names = o1.getNamesRef();
                String[] at2Names = o2.getNamesRef();
                if (at1Names != null && at2Names != null && at1Names.length > 0 && at2Names.length > 0) {
                    return at1Names[0].compareToIgnoreCase(at2Names[0]);
                }
                return 0;
            }
        });
        this.optionalAttributeTypesTableViewer.refresh();
    }

    public List<AttributeTypeImpl> getOptionalAttributeTypes() {
        return this.optionalAttributeTypesList;
    }

    public String[] getOptionalAttributeTypesNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeTypeImpl at : this.optionalAttributeTypesList) {
            names.add(at.getName());
        }
        return names.toArray(new String[0]);
    }
}

