/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewObjectClassMandatoryAttributesPage
extends WizardPage {
    private List<AttributeTypeImpl> mandatoryAttributeTypesList;
    private TableViewer mandatoryAttributeTypesTableViewer;
    private Button mandatoryAttributeTypesAddButton;
    private Button mandatoryAttributeTypesRemoveButton;

    protected NewObjectClassMandatoryAttributesPage() {
        super("NewObjectClassMandatoryAttributesPage");
        this.setTitle(Messages.getString("NewObjectClassMandatoryAttributesPage.MandatoryAttributeTypes"));
        this.setDescription(Messages.getString("NewObjectClassMandatoryAttributesPage.SpecifiyMandatoryAttributeTypeForObjectClass"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/object_class_new_wizard.png"));
        this.mandatoryAttributeTypesList = new ArrayList<AttributeTypeImpl>();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group mandatoryAttributeTypesGroup = new Group(composite, 0);
        mandatoryAttributeTypesGroup.setText(Messages.getString("NewObjectClassMandatoryAttributesPage.MandatoryAttributeTypes"));
        mandatoryAttributeTypesGroup.setLayout((Layout)new GridLayout(2, false));
        mandatoryAttributeTypesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Table mandatoryAttributeTypesTable = new Table((Composite)mandatoryAttributeTypesGroup, 2048);
        GridData mandatoryAttributeTypesTableGridData = new GridData(4, 4, true, true, 1, 2);
        mandatoryAttributeTypesTableGridData.heightHint = 100;
        mandatoryAttributeTypesTable.setLayoutData((Object)mandatoryAttributeTypesTableGridData);
        this.mandatoryAttributeTypesTableViewer = new TableViewer(mandatoryAttributeTypesTable);
        this.mandatoryAttributeTypesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mandatoryAttributeTypesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof AttributeTypeImpl) {
                    return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof AttributeTypeImpl) {
                    AttributeTypeImpl at = (AttributeTypeImpl)((Object)element);
                    String[] names = at.getNamesRef();
                    if (names != null && names.length > 0) {
                        return NLS.bind((String)Messages.getString("NewObjectClassMandatoryAttributesPage.AliasOID"), (Object[])new String[]{ViewUtils.concateAliases(names), at.getOid()});
                    }
                    return NLS.bind((String)Messages.getString("NewObjectClassMandatoryAttributesPage.NoneOID"), (Object[])new String[]{at.getOid()});
                }
                return super.getText(element);
            }
        });
        this.mandatoryAttributeTypesTableViewer.setInput(this.mandatoryAttributeTypesList);
        this.mandatoryAttributeTypesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewObjectClassMandatoryAttributesPage.this.mandatoryAttributeTypesRemoveButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.mandatoryAttributeTypesAddButton = new Button((Composite)mandatoryAttributeTypesGroup, 8);
        this.mandatoryAttributeTypesAddButton.setText(Messages.getString("NewObjectClassMandatoryAttributesPage.Add"));
        this.mandatoryAttributeTypesAddButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.mandatoryAttributeTypesAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassMandatoryAttributesPage.this.addMandatoryAttributeType();
            }
        });
        this.mandatoryAttributeTypesRemoveButton = new Button((Composite)mandatoryAttributeTypesGroup, 8);
        this.mandatoryAttributeTypesRemoveButton.setText(Messages.getString("NewObjectClassMandatoryAttributesPage.Remove"));
        this.mandatoryAttributeTypesRemoveButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.mandatoryAttributeTypesRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassMandatoryAttributesPage.this.removeMandatoryAttributeType();
            }
        });
        this.mandatoryAttributeTypesRemoveButton.setEnabled(false);
        this.setControl((Control)composite);
    }

    private void addMandatoryAttributeType() {
        AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
        ArrayList<AttributeTypeImpl> hiddenAttributes = new ArrayList<AttributeTypeImpl>();
        hiddenAttributes.addAll(this.mandatoryAttributeTypesList);
        dialog.setHiddenAttributeTypes(hiddenAttributes);
        if (dialog.open() == 0) {
            this.mandatoryAttributeTypesList.add(dialog.getSelectedAttributeType());
            this.updateMandatoryAttributeTypesTableTable();
        }
    }

    private void removeMandatoryAttributeType() {
        StructuredSelection selection = (StructuredSelection)this.mandatoryAttributeTypesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.mandatoryAttributeTypesList.remove(selection.getFirstElement());
            this.updateMandatoryAttributeTypesTableTable();
        }
    }

    private void updateMandatoryAttributeTypesTableTable() {
        Collections.sort(this.mandatoryAttributeTypesList, new Comparator<AttributeTypeImpl>(){

            @Override
            public int compare(AttributeTypeImpl o1, AttributeTypeImpl o2) {
                String[] at1Names = o1.getNamesRef();
                String[] at2Names = o2.getNamesRef();
                if (at1Names != null && at2Names != null && at1Names.length > 0 && at2Names.length > 0) {
                    return at1Names[0].compareToIgnoreCase(at2Names[0]);
                }
                return 0;
            }
        });
        this.mandatoryAttributeTypesTableViewer.refresh();
    }

    public List<AttributeTypeImpl> getMandatoryAttributeTypes() {
        return this.mandatoryAttributeTypesList;
    }

    public String[] getMandatoryAttributeTypesNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeTypeImpl at : this.mandatoryAttributeTypesList) {
            names.add(at.getName());
        }
        return names.toArray(new String[0]);
    }
}

