/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.alias.Alias;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithPartError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithStartError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringParser;
import org.apache.directory.studio.schemaeditor.view.dialogs.EditAliasesDialog;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewObjectClassGeneralPageWizardPage
extends AbstractWizardPage {
    private SchemaHandler schemaHandler;
    private List<Alias> aliases;
    private Schema selectedSchema;
    private ComboViewer schemaComboViewer;
    private Combo oidCombo;
    private Text aliasesText;
    private Button aliasesButton;
    private Text descriptionText;

    protected NewObjectClassGeneralPageWizardPage() {
        super("NewObjectClassGeneralPageWizardPage");
        this.setTitle(Messages.getString("NewObjectClassGeneralPageWizardPage.ObjectClass"));
        this.setDescription(Messages.getString("NewObjectClassGeneralPageWizardPage.CreateObjectClass"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/object_class_new_wizard.png"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
        this.aliases = new ArrayList<Alias>();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group schemaGroup = new Group(composite, 0);
        schemaGroup.setText(Messages.getString("NewObjectClassGeneralPageWizardPage.Schema"));
        schemaGroup.setLayout((Layout)new GridLayout(2, false));
        schemaGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label schemaLabel = new Label((Composite)schemaGroup, 0);
        schemaLabel.setText(Messages.getString("NewObjectClassGeneralPageWizardPage.SchemaColon"));
        Combo schemaCombo = new Combo((Composite)schemaGroup, 8);
        schemaCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.schemaComboViewer = new ComboViewer(schemaCombo);
        this.schemaComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.schemaComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Schema) {
                    return ((Schema)element).getName();
                }
                return super.getText(element);
            }
        });
        this.schemaComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewObjectClassGeneralPageWizardPage.this.dialogChanged();
            }
        });
        Group namingDescriptionGroup = new Group(composite, 0);
        namingDescriptionGroup.setText(Messages.getString("NewObjectClassGeneralPageWizardPage.NamingAndDescription"));
        namingDescriptionGroup.setLayout((Layout)new GridLayout(3, false));
        namingDescriptionGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label oidLabel = new Label((Composite)namingDescriptionGroup, 0);
        oidLabel.setText(Messages.getString("NewObjectClassGeneralPageWizardPage.OID"));
        this.oidCombo = new Combo((Composite)namingDescriptionGroup, 2052);
        this.oidCombo.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.oidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewObjectClassGeneralPageWizardPage.this.dialogChanged();
            }
        });
        this.oidCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("([0-9]*\\.?)*")) {
                    e.doit = false;
                }
            }
        });
        this.oidCombo.setItems(PluginUtils.loadDialogSettingsHistory(PluginConstants.DIALOG_SETTINGS_OID_HISTORY));
        Label aliasesLabel = new Label((Composite)namingDescriptionGroup, 0);
        aliasesLabel.setText(Messages.getString("NewObjectClassGeneralPageWizardPage.Aliases"));
        this.aliasesText = new Text((Composite)namingDescriptionGroup, 2048);
        this.aliasesText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.aliasesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AliasesStringParser parser = new AliasesStringParser();
                parser.parse(NewObjectClassGeneralPageWizardPage.this.aliasesText.getText());
                List<Alias> parsedAliases = parser.getAliases();
                NewObjectClassGeneralPageWizardPage.this.aliases.clear();
                for (Alias parsedAlias : parsedAliases) {
                    NewObjectClassGeneralPageWizardPage.this.aliases.add(parsedAlias);
                }
                NewObjectClassGeneralPageWizardPage.this.dialogChanged();
            }
        });
        this.aliasesButton = new Button((Composite)namingDescriptionGroup, 8);
        this.aliasesButton.setText(Messages.getString("NewObjectClassGeneralPageWizardPage.Edit"));
        this.aliasesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EditAliasesDialog dialog = new EditAliasesDialog(NewObjectClassGeneralPageWizardPage.this.getAliasesValue());
                if (dialog.open() == 0 && dialog.isDirty()) {
                    String[] newAliases = dialog.getAliases();
                    StringBuffer sb = new StringBuffer();
                    for (String newAlias : newAliases) {
                        sb.append(newAlias);
                        sb.append(", ");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.deleteCharAt(sb.length() - 1);
                    AliasesStringParser parser = new AliasesStringParser();
                    parser.parse(sb.toString());
                    List<Alias> parsedAliases = parser.getAliases();
                    NewObjectClassGeneralPageWizardPage.this.aliases.clear();
                    for (Alias parsedAlias : parsedAliases) {
                        NewObjectClassGeneralPageWizardPage.this.aliases.add(parsedAlias);
                    }
                    NewObjectClassGeneralPageWizardPage.this.fillInAliasesLabel();
                    NewObjectClassGeneralPageWizardPage.this.dialogChanged();
                }
            }
        });
        Label descriptionLabel = new Label((Composite)namingDescriptionGroup, 0);
        descriptionLabel.setText(Messages.getString("NewObjectClassGeneralPageWizardPage.Description"));
        this.descriptionText = new Text((Composite)namingDescriptionGroup, 2562);
        GridData descriptionGridData = new GridData(4, 0, true, false, 2, 1);
        descriptionGridData.heightHint = 67;
        this.descriptionText.setLayoutData((Object)descriptionGridData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewObjectClassGeneralPageWizardPage.this.dialogChanged();
            }
        });
        this.initFields();
        this.setControl((Control)composite);
    }

    private void initFields() {
        if (this.schemaHandler == null) {
            this.schemaComboViewer.getCombo().setEnabled(false);
            this.oidCombo.setEnabled(false);
            this.aliasesText.setEnabled(false);
            this.aliasesButton.setEnabled(false);
            this.descriptionText.setEnabled(false);
            this.displayErrorMessage(Messages.getString("NewObjectClassGeneralPageWizardPage.ErrorNoSchemaProjectOpen"));
        } else {
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            schemas.addAll(this.schemaHandler.getSchemas());
            Collections.sort(schemas, new Comparator<Schema>(){

                @Override
                public int compare(Schema o1, Schema o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            this.schemaComboViewer.setInput(schemas);
            if (this.selectedSchema != null) {
                this.schemaComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedSchema));
            }
            this.displayErrorMessage(null);
        }
        this.setPageComplete(false);
    }

    private void dialogChanged() {
        if (this.schemaComboViewer.getSelection().isEmpty()) {
            this.displayErrorMessage(Messages.getString("NewObjectClassGeneralPageWizardPage.ErrorNoSchemaSpecified"));
            return;
        }
        if (this.oidCombo.getText().equals("")) {
            this.displayErrorMessage(Messages.getString("NewObjectClassGeneralPageWizardPage.ErrorNoOIDSpecified"));
            return;
        }
        if (!this.oidCombo.getText().equals("") && !OID.isOID((String)this.oidCombo.getText())) {
            this.displayErrorMessage(Messages.getString("NewObjectClassGeneralPageWizardPage.ErrorIncorrectOID"));
            return;
        }
        if (!this.oidCombo.getText().equals("") && OID.isOID((String)this.oidCombo.getText()) && this.schemaHandler.isAliasOrOidAlreadyTaken(this.oidCombo.getText())) {
            this.displayErrorMessage(Messages.getString("NewObjectClassGeneralPageWizardPage.ErrorObjectOIDExists"));
            return;
        }
        if (this.aliases.size() == 0) {
            this.displayWarningMessage(Messages.getString("NewObjectClassGeneralPageWizardPage.ErrorObjectClassNoName"));
            return;
        }
        for (Alias alias : this.aliases) {
            if (alias instanceof AliasWithStartError) {
                this.displayErrorMessage(NLS.bind((String)Messages.getString("NewObjectClassGeneralPageWizardPage.AliasStartInvalid"), (Object[])new Object[]{alias, Character.valueOf(((AliasWithStartError)alias).getErrorChar())}));
                return;
            }
            if (!(alias instanceof AliasWithPartError)) continue;
            this.displayErrorMessage(NLS.bind((String)Messages.getString("NewObjectClassGeneralPageWizardPage.AliasPartInvalid"), (Object[])new Object[]{alias, Character.valueOf(((AliasWithPartError)alias).getErrorChar())}));
            return;
        }
        this.displayErrorMessage(null);
    }

    private void fillInAliasesLabel() {
        StringBuffer sb = new StringBuffer();
        for (Alias alias : this.aliases) {
            sb.append(alias);
            sb.append(", ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.deleteCharAt(sb.length() - 1);
        this.aliasesText.setText(sb.toString());
    }

    public String getSchemaValue() {
        StructuredSelection selection = (StructuredSelection)this.schemaComboViewer.getSelection();
        if (!selection.isEmpty()) {
            Schema schema = (Schema)selection.getFirstElement();
            return schema.getName();
        }
        return null;
    }

    public String getOidValue() {
        return this.oidCombo.getText();
    }

    public String[] getAliasesValue() {
        ArrayList<String> aliasesValue = new ArrayList<String>();
        for (Alias alias : this.aliases) {
            aliasesValue.add(alias.toString());
        }
        return aliasesValue.toArray(new String[0]);
    }

    public String getDescriptionValue() {
        return this.descriptionText.getText();
    }

    public void setSelectedSchema(Schema schema) {
        this.selectedSchema = schema;
    }
}

