/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.ObjectClassSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class NewObjectClassContentWizardPage
extends WizardPage {
    private List<ObjectClassImpl> superiorsList;
    private ObjectClassTypeEnum type = ObjectClassTypeEnum.STRUCTURAL;
    private TableViewer superiorsTableViewer;
    private Button superiorsAddButton;
    private Button superiorsRemoveButton;
    private Button structuralRadio;
    private Button abstractRadio;
    private Button auxiliaryRadio;
    private Button obsoleteCheckbox;

    protected NewObjectClassContentWizardPage() {
        super("NewObjectClassContentWizardPage");
        this.setTitle(Messages.getString("NewObjectClassContentWizardPage.ObjectClassContent"));
        this.setDescription(Messages.getString("NewObjectClassContentWizardPage.EnterObjectClassContent"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/object_class_new_wizard.png"));
        this.superiorsList = new ArrayList<ObjectClassImpl>();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group superiorsGroup = new Group(composite, 0);
        superiorsGroup.setText(Messages.getString("NewObjectClassContentWizardPage.Superiors"));
        superiorsGroup.setLayout((Layout)new GridLayout(2, false));
        superiorsGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Table superiorsTable = new Table((Composite)superiorsGroup, 2048);
        GridData superiorsTableGridData = new GridData(4, 4, true, true, 1, 2);
        superiorsTableGridData.heightHint = 100;
        superiorsTable.setLayoutData((Object)superiorsTableGridData);
        this.superiorsTableViewer = new TableViewer(superiorsTable);
        this.superiorsTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof ObjectClassImpl) {
                    return Activator.getDefault().getImage("resources/icons/object_class.gif");
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof ObjectClassImpl) {
                    ObjectClassImpl oc = (ObjectClassImpl)((Object)element);
                    String[] names = oc.getNamesRef();
                    if (names != null && names.length > 0) {
                        return NLS.bind((String)Messages.getString("NewObjectClassContentWizardPage.AliasOID"), (Object[])new String[]{ViewUtils.concateAliases(names), oc.getOid()});
                    }
                    return NLS.bind((String)Messages.getString("NewObjectClassContentWizardPage.NoneOID"), (Object[])new String[]{oc.getOid()});
                }
                return super.getText(element);
            }
        });
        this.superiorsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.superiorsTableViewer.setInput(this.superiorsList);
        this.superiorsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewObjectClassContentWizardPage.this.superiorsRemoveButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.superiorsAddButton = new Button((Composite)superiorsGroup, 8);
        this.superiorsAddButton.setText(Messages.getString("NewObjectClassContentWizardPage.Add"));
        this.superiorsAddButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.superiorsAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassContentWizardPage.this.addSuperiorObjectClass();
            }
        });
        this.superiorsRemoveButton = new Button((Composite)superiorsGroup, 8);
        this.superiorsRemoveButton.setText(Messages.getString("NewObjectClassContentWizardPage.Remove"));
        this.superiorsRemoveButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.superiorsRemoveButton.setEnabled(false);
        this.superiorsRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassContentWizardPage.this.removeSuperiorObjectClass();
            }
        });
        Group classTypeGroup = new Group(composite, 0);
        classTypeGroup.setText(Messages.getString("NewObjectClassContentWizardPage.ClassType"));
        classTypeGroup.setLayout((Layout)new GridLayout(5, false));
        classTypeGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label classTypeLable = new Label((Composite)classTypeGroup, 0);
        classTypeLable.setText(Messages.getString("NewObjectClassContentWizardPage.ClassTypeColon"));
        new Label((Composite)classTypeGroup, 0).setText("          ");
        this.structuralRadio = new Button((Composite)classTypeGroup, 16);
        this.structuralRadio.setText(Messages.getString("NewObjectClassContentWizardPage.Structural"));
        GridData structuralRadioGridData = new GridData(16384, 0, false, false);
        structuralRadioGridData.widthHint = 115;
        this.structuralRadio.setLayoutData((Object)structuralRadioGridData);
        this.structuralRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassContentWizardPage.this.type = ObjectClassTypeEnum.STRUCTURAL;
            }
        });
        this.structuralRadio.setSelection(true);
        this.abstractRadio = new Button((Composite)classTypeGroup, 16);
        this.abstractRadio.setText(Messages.getString("NewObjectClassContentWizardPage.Abstract"));
        GridData abstractRadioGridData = new GridData(16384, 0, false, false);
        abstractRadioGridData.widthHint = 115;
        this.abstractRadio.setLayoutData((Object)structuralRadioGridData);
        this.abstractRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassContentWizardPage.this.type = ObjectClassTypeEnum.ABSTRACT;
            }
        });
        this.auxiliaryRadio = new Button((Composite)classTypeGroup, 16);
        this.auxiliaryRadio.setText(Messages.getString("NewObjectClassContentWizardPage.Auxiliary"));
        GridData auxiliaryRadioGridData = new GridData(16384, 0, false, false);
        auxiliaryRadioGridData.widthHint = 115;
        this.auxiliaryRadio.setLayoutData((Object)structuralRadioGridData);
        this.auxiliaryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassContentWizardPage.this.type = ObjectClassTypeEnum.AUXILIARY;
            }
        });
        Group propertiesGroup = new Group(composite, 0);
        propertiesGroup.setText(Messages.getString("NewObjectClassContentWizardPage.Properties"));
        propertiesGroup.setLayout((Layout)new GridLayout());
        propertiesGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.obsoleteCheckbox = new Button((Composite)propertiesGroup, 32);
        this.obsoleteCheckbox.setText(Messages.getString("NewObjectClassContentWizardPage.Obsolete"));
        this.setControl((Control)composite);
    }

    private void addSuperiorObjectClass() {
        ObjectClassSelectionDialog dialog = new ObjectClassSelectionDialog();
        dialog.setHiddenObjectClasses(this.superiorsList);
        if (dialog.open() == 0) {
            this.superiorsList.add(dialog.getSelectedObjectClass());
            this.updateSuperiorsTable();
        }
    }

    private void removeSuperiorObjectClass() {
        StructuredSelection selection = (StructuredSelection)this.superiorsTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.superiorsList.remove(selection.getFirstElement());
            this.updateSuperiorsTable();
        }
    }

    private void updateSuperiorsTable() {
        Collections.sort(this.superiorsList, new Comparator<ObjectClassImpl>(){

            @Override
            public int compare(ObjectClassImpl o1, ObjectClassImpl o2) {
                String[] at1Names = o1.getNamesRef();
                String[] at2Names = o2.getNamesRef();
                if (at1Names != null && at2Names != null && at1Names.length > 0 && at2Names.length > 0) {
                    return at1Names[0].compareToIgnoreCase(at2Names[0]);
                }
                return 0;
            }
        });
        this.superiorsTableViewer.refresh();
    }

    public String[] getSuperiorsNameValue() {
        ArrayList<String> names = new ArrayList<String>();
        for (ObjectClassImpl oc : this.superiorsList) {
            String[] aliases = oc.getNamesRef();
            if (aliases != null && aliases.length > 0) {
                names.add(aliases[0]);
                continue;
            }
            names.add(oc.getOid());
        }
        return names.toArray(new String[0]);
    }

    public ObjectClassTypeEnum getClassTypeValue() {
        return this.type;
    }

    public boolean getObsoleteValue() {
        return this.obsoleteCheckbox.getSelection();
    }
}

