/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewAttributeTypeMatchingRulesWizardPage
extends WizardPage {
    private SchemaHandler schemaHandler;
    private LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof MatchingRuleImpl) {
                MatchingRuleImpl mr = (MatchingRuleImpl)((Object)element);
                String name = mr.getName();
                if (name != null) {
                    return NLS.bind((String)Messages.getString("NewAttributeTypeMatchingRulesWizardPage.NameOID"), (Object[])new String[]{name, mr.getOid()});
                }
                return NLS.bind((String)Messages.getString("NewAttributeTypeMatchingRulesWizardPage.NoneOID"), (Object[])new String[]{mr.getOid()});
            }
            return super.getText(element);
        }
    };
    private ComboViewer equalityComboViewer;
    private ComboViewer orderingComboViewer;
    private ComboViewer substringComboViewer;

    public NewAttributeTypeMatchingRulesWizardPage() {
        super("NewAttributeTypeMatchingRulesWizardPage");
        this.setTitle(Messages.getString("NewAttributeTypeMatchingRulesWizardPage.MatchingRules"));
        this.setDescription(Messages.getString("NewAttributeTypeMatchingRulesWizardPage.PleaseSpecifiyMatchingRules"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/attribute_type_new_wizard.png"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group matchingRulesGroup = new Group(composite, 0);
        matchingRulesGroup.setText(Messages.getString("NewAttributeTypeMatchingRulesWizardPage.MatchingRules"));
        matchingRulesGroup.setLayout((Layout)new GridLayout(2, false));
        matchingRulesGroup.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        Label equalityLabel = new Label((Composite)matchingRulesGroup, 0);
        equalityLabel.setText(Messages.getString("NewAttributeTypeMatchingRulesWizardPage.Equality"));
        Combo equalityCombo = new Combo((Composite)matchingRulesGroup, 8);
        equalityCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.equalityComboViewer = new ComboViewer(equalityCombo);
        this.equalityComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.equalityComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Label orderingLabel = new Label((Composite)matchingRulesGroup, 0);
        orderingLabel.setText(Messages.getString("NewAttributeTypeMatchingRulesWizardPage.Ordering"));
        Combo orderingCombo = new Combo((Composite)matchingRulesGroup, 8);
        orderingCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.orderingComboViewer = new ComboViewer(orderingCombo);
        this.orderingComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.orderingComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Label substringLabel = new Label((Composite)matchingRulesGroup, 0);
        substringLabel.setText(Messages.getString("NewAttributeTypeMatchingRulesWizardPage.Substring"));
        Combo substringCombo = new Combo((Composite)matchingRulesGroup, 8);
        substringCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.substringComboViewer = new ComboViewer(substringCombo);
        this.substringComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.substringComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.initFields();
        this.setControl((Control)composite);
    }

    private void initFields() {
        if (this.schemaHandler != null) {
            ArrayList<MatchingRuleImpl> matchingRules = new ArrayList<MatchingRuleImpl>(this.schemaHandler.getMatchingRules());
            String none = Messages.getString("NewAttributeTypeMatchingRulesWizardPage.None");
            matchingRules.add((MatchingRuleImpl)((Object)none));
            Collections.sort(matchingRules, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof MatchingRuleImpl && o2 instanceof MatchingRuleImpl) {
                        String[] o1Names = ((MatchingRuleImpl)((Object)o1)).getNamesRef();
                        String[] o2Names = ((MatchingRuleImpl)((Object)o2)).getNamesRef();
                        if (o1Names != null && o2Names != null) {
                            if (o1Names.length > 0 && o2Names.length > 0) {
                                return o1Names[0].compareToIgnoreCase(o2Names[0]);
                            }
                            if (o1Names.length == 0 && o2Names.length > 0) {
                                return "".compareToIgnoreCase(o2Names[0]);
                            }
                            if (o1Names.length > 0 && o2Names.length == 0) {
                                return o1Names[0].compareToIgnoreCase("");
                            }
                        } else {
                            if (o1 instanceof String && o2 instanceof MatchingRuleImpl) {
                                return Integer.MIN_VALUE;
                            }
                            if (o1 instanceof MatchingRuleImpl && o2 instanceof String) {
                                return Integer.MAX_VALUE;
                            }
                        }
                    }
                    return o1.toString().compareToIgnoreCase(o2.toString());
                }
            });
            this.equalityComboViewer.setInput(matchingRules);
            this.orderingComboViewer.setInput(matchingRules);
            this.substringComboViewer.setInput(matchingRules);
            this.equalityComboViewer.setSelection((ISelection)new StructuredSelection((Object)none));
            this.orderingComboViewer.setSelection((ISelection)new StructuredSelection((Object)none));
            this.substringComboViewer.setSelection((ISelection)new StructuredSelection((Object)none));
        }
    }

    public String getEqualityMatchingRuleValue() {
        Object selection = ((StructuredSelection)this.equalityComboViewer.getSelection()).getFirstElement();
        if (selection instanceof MatchingRuleImpl) {
            MatchingRuleImpl mr = (MatchingRuleImpl)((Object)selection);
            String[] names = mr.getNamesRef();
            if (names != null && names.length > 0) {
                return mr.getName();
            }
            return mr.getOid();
        }
        return null;
    }

    public String getOrderingMatchingRuleValue() {
        Object selection = ((StructuredSelection)this.orderingComboViewer.getSelection()).getFirstElement();
        if (selection instanceof MatchingRuleImpl) {
            MatchingRuleImpl mr = (MatchingRuleImpl)((Object)selection);
            String[] names = mr.getNamesRef();
            if (names != null && names.length > 0) {
                return mr.getName();
            }
            return mr.getOid();
        }
        return null;
    }

    public String getSubstringMatchingRuleValue() {
        Object selection = ((StructuredSelection)this.substringComboViewer.getSelection()).getFirstElement();
        if (selection instanceof MatchingRuleImpl) {
            MatchingRuleImpl mr = (MatchingRuleImpl)((Object)selection);
            String[] names = mr.getNamesRef();
            if (names != null && names.length > 0) {
                return mr.getName();
            }
            return mr.getOid();
        }
        return null;
    }
}

