/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SchemaImpl;
import org.apache.directory.studio.schemaeditor.view.dialogs.MessageDialogWithTextarea;
import org.apache.directory.studio.schemaeditor.view.wizards.MergeSchemasOptionsWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.MergeSchemasSelectionWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSchemasWizard
extends Wizard
implements IImportWizard {
    private MergeSchemasSelectionWizardPage selectionPage;
    private MergeSchemasOptionsWizardPage optionsPage;

    public void addPages() {
        this.selectionPage = new MergeSchemasSelectionWizardPage();
        this.optionsPage = new MergeSchemasOptionsWizardPage();
        this.addPage((IWizardPage)this.selectionPage);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean performFinish() {
        Object[] sourceObjects = this.selectionPage.getSelectedObjects();
        boolean replaceUnknownSyntax = this.optionsPage.isReplaceUnknownSyntax();
        boolean mergeDependencies = this.optionsPage.isMergeDependencies();
        boolean pullUpAttributes = this.optionsPage.isPullUpAttributes();
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.mergeObjects(sourceObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
        if (!errorMessages.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String errorMessage : errorMessages) {
                sb.append(errorMessage);
                sb.append('\n');
            }
            new MessageDialogWithTextarea(this.getShell(), Messages.getString("MergeSchemasWizard.MergeResultTitle"), Messages.getString("MergeSchemasWizard.MergeResultMessage"), sb.toString()).open();
        }
        return true;
    }

    private void mergeObjects(Object[] sourceObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        HashSet<Object> processedObjects = new HashSet<Object>();
        HashMap<String, Schema> targetSchemas = new HashMap<String, Schema>();
        Project targetProject = Activator.getDefault().getProjectsHandler().getOpenProject();
        for (Object sourceObject : sourceObjects) {
            Schema targetSchema;
            if (sourceObject instanceof Project) {
                Project sourceProject = (Project)sourceObject;
                for (Schema sourceSchema : sourceProject.getSchemaHandler().getSchemas()) {
                    Schema targetSchema2 = this.getTargetSchema(sourceSchema.getProject(), targetProject, targetSchemas);
                    this.mergeSchema(sourceSchema, targetProject, targetSchema2, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            if (sourceObject instanceof Schema) {
                Schema sourceSchema = (Schema)sourceObject;
                targetSchema = this.getTargetSchema(sourceSchema.getProject(), targetProject, targetSchemas);
                this.mergeSchema(sourceSchema, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
            }
            if (sourceObject instanceof MergeSchemasSelectionWizardPage.AttributeTypeFolder) {
                MergeSchemasSelectionWizardPage.AttributeTypeFolder atf = (MergeSchemasSelectionWizardPage.AttributeTypeFolder)sourceObject;
                targetSchema = this.getTargetSchema(atf.schema.getProject(), targetProject, targetSchemas);
                List<AttributeTypeImpl> sourceAttributeTypes = atf.schema.getAttributeTypes();
                for (AttributeTypeImpl sourceAttributeType : sourceAttributeTypes) {
                    this.mergeAttributeType(sourceAttributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            if (sourceObject instanceof MergeSchemasSelectionWizardPage.ObjectClassFolder) {
                MergeSchemasSelectionWizardPage.ObjectClassFolder ocf = (MergeSchemasSelectionWizardPage.ObjectClassFolder)sourceObject;
                targetSchema = this.getTargetSchema(ocf.schema.getProject(), targetProject, targetSchemas);
                List<ObjectClassImpl> sourceObjectClasses = ocf.schema.getObjectClasses();
                for (ObjectClassImpl sourceObjectClass : sourceObjectClasses) {
                    this.mergeObjectClass(sourceObjectClass, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            if (sourceObject instanceof AttributeTypeImpl) {
                AttributeTypeImpl at = (AttributeTypeImpl)((Object)sourceObject);
                targetSchema = this.getTargetSchema(at.getSchemaObject().getProject(), targetProject, targetSchemas);
                this.mergeAttributeType(at, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
            }
            if (!(sourceObject instanceof ObjectClassImpl)) continue;
            ObjectClassImpl oc = (ObjectClassImpl)((Object)sourceObject);
            targetSchema = this.getTargetSchema(oc.getSchemaObject().getProject(), targetProject, targetSchemas);
            this.mergeObjectClass(oc, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
        }
        for (Schema targetSchema : targetSchemas.values()) {
            if (targetProject.getSchemaHandler().getSchemas().contains(targetSchema)) continue;
            targetProject.getSchemaHandler().addSchema(targetSchema);
        }
    }

    private Schema getTargetSchema(Project sourceProject, Project targetProject, Map<String, Schema> targetSchemas) {
        String targetSchemaName = "merge-from-" + sourceProject.getName();
        Schema targetSchema = targetProject.getSchemaHandler().getSchema(targetSchemaName);
        if (targetSchema != null) {
            targetProject.getSchemaHandler().removeSchema(targetSchema);
        } else if (targetSchemas.containsKey(targetSchemaName)) {
            targetSchema = targetSchemas.get(targetSchemaName);
        } else {
            targetSchema = new SchemaImpl(targetSchemaName);
            targetSchema.setProject(targetProject);
        }
        targetSchemas.put(targetSchemaName, targetSchema);
        return targetSchema;
    }

    private void mergeSchema(Schema sourceSchema, Project targetProject, Schema targetSchema, Set<Object> processedObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        List<AttributeTypeImpl> sourceAttributeTypes = sourceSchema.getAttributeTypes();
        for (AttributeTypeImpl sourceAttributeType : sourceAttributeTypes) {
            this.mergeAttributeType(sourceAttributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
        }
        List<ObjectClassImpl> sourceObjectClasses = sourceSchema.getObjectClasses();
        for (ObjectClassImpl sourceObjectClass : sourceObjectClasses) {
            this.mergeObjectClass(sourceObjectClass, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
        }
    }

    private void mergeAttributeType(AttributeTypeImpl sourceAttributeType, Project targetProject, Schema targetSchema, Set<Object> processedObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        boolean oidOrAliasAlreadyTaken;
        if (processedObjects.contains((Object)sourceAttributeType)) {
            return;
        }
        processedObjects.add((Object)sourceAttributeType);
        AttributeTypeImpl targetAttributeType = targetProject.getSchemaHandler().getAttributeType(sourceAttributeType.getOid());
        if (targetAttributeType == null) {
            for (String name : sourceAttributeType.getNamesRef()) {
                targetAttributeType = targetProject.getSchemaHandler().getAttributeType(name);
                if (targetAttributeType != null) break;
            }
        }
        if (!(oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isAliasOrOidAlreadyTaken(sourceAttributeType.getOid()))) {
            for (String name : sourceAttributeType.getNamesRef()) {
                oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isAliasOrOidAlreadyTaken(name);
                if (oidOrAliasAlreadyTaken) break;
            }
        }
        if (targetAttributeType != null) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.AttributeTypeExistsInTargetProject"), (Object)this.getIdString((AbstractSchemaObject)sourceAttributeType)));
        } else if (oidOrAliasAlreadyTaken) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.OidOrAliasAlreadyTaken"), (Object)this.getIdString((AbstractSchemaObject)sourceAttributeType)));
        } else {
            AttributeTypeImpl superiorAttributeType;
            String superiorName;
            AttributeTypeImpl at = targetSchema.getAttributeType(sourceAttributeType.getOid());
            if (at != null) {
                targetSchema.removeAttributeType(at);
            }
            AttributeTypeImpl clonedAttributeType = new AttributeTypeImpl(sourceAttributeType.getOid());
            clonedAttributeType.setOid(sourceAttributeType.getOid());
            clonedAttributeType.setNames(sourceAttributeType.getNamesRef());
            clonedAttributeType.setDescription(sourceAttributeType.getDescription());
            clonedAttributeType.setSuperiorName(sourceAttributeType.getSuperiorName());
            clonedAttributeType.setUsage(sourceAttributeType.getUsage());
            clonedAttributeType.setSyntaxOid(sourceAttributeType.getSyntaxOid());
            clonedAttributeType.setLength(sourceAttributeType.getLength());
            clonedAttributeType.setObsolete(sourceAttributeType.isObsolete());
            clonedAttributeType.setCollective(sourceAttributeType.isCollective());
            clonedAttributeType.setSingleValue(sourceAttributeType.isSingleValue());
            clonedAttributeType.setCanUserModify(sourceAttributeType.isCanUserModify());
            clonedAttributeType.setEqualityName(sourceAttributeType.getEqualityName());
            clonedAttributeType.setOrderingName(sourceAttributeType.getOrderingName());
            clonedAttributeType.setSubstrName(sourceAttributeType.getSubstrName());
            clonedAttributeType.setSchema(targetSchema.getName());
            clonedAttributeType.setSchemaObject(targetSchema);
            if (replaceUnknownSyntax && (clonedAttributeType.getSyntaxOid() == null || targetProject.getSchemaHandler().getSyntax(clonedAttributeType.getSyntaxOid()) == null)) {
                errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.ReplacedSyntax"), (Object[])new String[]{this.getIdString((AbstractSchemaObject)sourceAttributeType), clonedAttributeType.getSyntaxOid(), "1.3.6.1.4.1.1466.115.121.1.15 (Directory String)"}));
                clonedAttributeType.setSyntaxOid("1.3.6.1.4.1.1466.115.121.1.15");
                clonedAttributeType.setEqualityName("caseIgnoreMatch");
                clonedAttributeType.setOrderingName(null);
                clonedAttributeType.setSubstrName("caseIgnoreSubstringsMatch");
            }
            if (mergeDependencies && (superiorName = clonedAttributeType.getSuperiorName()) != null && (superiorAttributeType = sourceAttributeType.getSchemaObject().getProject().getSchemaHandler().getAttributeType(superiorName)) != null) {
                this.mergeAttributeType(superiorAttributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
            }
            targetSchema.addAttributeType(clonedAttributeType);
        }
    }

    private void mergeObjectClass(ObjectClassImpl sourceObjectClass, Project targetProject, Schema targetSchema, Set<Object> processedObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        boolean oidOrAliasAlreadyTaken;
        if (processedObjects.contains((Object)sourceObjectClass)) {
            return;
        }
        processedObjects.add((Object)sourceObjectClass);
        ObjectClassImpl targetObjectClass = targetProject.getSchemaHandler().getObjectClass(sourceObjectClass.getOid());
        if (targetObjectClass == null) {
            for (String name : sourceObjectClass.getNamesRef()) {
                targetObjectClass = targetProject.getSchemaHandler().getObjectClass(name);
                if (targetObjectClass != null) break;
            }
        }
        if (!(oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isAliasOrOidAlreadyTaken(sourceObjectClass.getOid()))) {
            for (String name : sourceObjectClass.getNamesRef()) {
                oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isAliasOrOidAlreadyTaken(name);
                if (oidOrAliasAlreadyTaken) break;
            }
        }
        if (targetObjectClass != null) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.ObjectClassExistsInTargetProject"), (Object)this.getIdString(sourceObjectClass)));
        } else if (oidOrAliasAlreadyTaken) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.OidOrAliasAlreadyTaken"), (Object)this.getIdString(sourceObjectClass)));
        } else {
            ObjectClassImpl oc = targetSchema.getObjectClass(sourceObjectClass.getOid());
            if (oc != null) {
                targetSchema.removeObjectClass(oc);
            }
            ObjectClassImpl clonedObjectClass = new ObjectClassImpl(sourceObjectClass.getOid());
            clonedObjectClass.setOid(sourceObjectClass.getOid());
            clonedObjectClass.setNames(sourceObjectClass.getNamesRef());
            clonedObjectClass.setDescription(sourceObjectClass.getDescription());
            clonedObjectClass.setSuperClassesNames(sourceObjectClass.getSuperClassesNames());
            clonedObjectClass.setType(sourceObjectClass.getType());
            clonedObjectClass.setObsolete(sourceObjectClass.isObsolete());
            clonedObjectClass.setMustNamesList(sourceObjectClass.getMustNamesList());
            clonedObjectClass.setMayNamesList(sourceObjectClass.getMayNamesList());
            clonedObjectClass.setSchema(targetSchema.getName());
            clonedObjectClass.setSchemaObject(targetSchema);
            if (mergeDependencies) {
                String[] superClassesNames = clonedObjectClass.getSuperClassesNames();
                if (superClassesNames != null) {
                    for (String superClassName : superClassesNames) {
                        if (superClassName == null) continue;
                        ObjectClassImpl superSourceObjectClass = sourceObjectClass.getSchemaObject().getProject().getSchemaHandler().getObjectClass(superClassName);
                        ObjectClassImpl superTargetObjectClass = targetProject.getSchemaHandler().getObjectClass(superClassName);
                        if (superSourceObjectClass == null) continue;
                        if (superTargetObjectClass == null) {
                            this.mergeObjectClass(superSourceObjectClass, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                            continue;
                        }
                        if (!pullUpAttributes) continue;
                        this.pullUpAttributes(clonedObjectClass, superSourceObjectClass, superTargetObjectClass);
                    }
                }
                String[] mustNamesList = clonedObjectClass.getMustNamesList();
                String[] mayNamesList = clonedObjectClass.getMayNamesList();
                ArrayList<String> attributeNames = new ArrayList<String>();
                if (mustNamesList != null) {
                    attributeNames.addAll(Arrays.asList(mustNamesList));
                }
                if (mayNamesList != null) {
                    attributeNames.addAll(Arrays.asList(mayNamesList));
                }
                for (String attributeName : attributeNames) {
                    AttributeTypeImpl attributeType;
                    if (attributeName == null || (attributeType = sourceObjectClass.getSchemaObject().getProject().getSchemaHandler().getAttributeType(attributeName)) == null) continue;
                    this.mergeAttributeType(attributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            targetSchema.addObjectClass(clonedObjectClass);
        }
    }

    private void pullUpAttributes(ObjectClassImpl targetObjectClass, ObjectClassImpl sourceSuperObjectClass, ObjectClassImpl targetSuperObjectClass) {
        HashSet<String> sourceMustAttributeNames = new HashSet<String>();
        this.fetchAttributes(sourceMustAttributeNames, sourceSuperObjectClass, true);
        HashSet<String> targetMustAttributeNames = new HashSet<String>();
        this.fetchAttributes(targetMustAttributeNames, targetSuperObjectClass, true);
        sourceMustAttributeNames.removeAll(targetMustAttributeNames);
        if (!sourceMustAttributeNames.isEmpty()) {
            sourceMustAttributeNames.addAll(Arrays.asList(targetObjectClass.getMustNamesList()));
            targetObjectClass.setMustNamesList(sourceMustAttributeNames.toArray(new String[0]));
        }
        HashSet<String> sourceMayAttributeNames = new HashSet<String>();
        this.fetchAttributes(sourceMayAttributeNames, sourceSuperObjectClass, false);
        HashSet<String> targetMayAttributeNames = new HashSet<String>();
        this.fetchAttributes(targetMayAttributeNames, targetSuperObjectClass, false);
        sourceMayAttributeNames.removeAll(targetMayAttributeNames);
        if (!sourceMayAttributeNames.isEmpty()) {
            sourceMayAttributeNames.addAll(Arrays.asList(targetObjectClass.getMayNamesList()));
            targetObjectClass.setMayNamesList(sourceMayAttributeNames.toArray(new String[0]));
        }
    }

    private void fetchAttributes(Set<String> attributeNameList, ObjectClassImpl oc, boolean must) {
        String[] attributeNames = must ? oc.getMustNamesList() : oc.getMayNamesList();
        attributeNameList.addAll(Arrays.asList(attributeNames));
        for (String superClassName : oc.getSuperClassesNames()) {
            ObjectClassImpl superObjectClass = oc.getSchemaObject().getProject().getSchemaHandler().getObjectClass(superClassName);
            this.fetchAttributes(attributeNameList, superObjectClass, must);
        }
    }

    private String getIdString(AbstractSchemaObject schemaObject) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (schemaObject.getNamesRef() != null) {
            for (String name : schemaObject.getNamesRef()) {
                sb.append(name);
                sb.append(',');
            }
        }
        sb.append(schemaObject.getOid());
        sb.append(']');
        return sb.toString();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

