/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class MergeSchemasSelectionWizardPage
extends AbstractWizardPage {
    private Project[] selectedProjects = new Project[0];
    private CheckboxTreeViewer projectsTreeViewer;

    protected MergeSchemasSelectionWizardPage() {
        super("MergeSchemasSelectionWizardPage");
        this.setTitle(Messages.getString("MergeSchemasSelectionWizardPage.ImportSchemasFromProjects"));
        this.setDescription(Messages.getString("MergeSchemasSelectionWizardPage.PleaseSelectElements"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/schemas_import_wizard.png"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label projectsLabel = new Label(composite, 0);
        projectsLabel.setText(Messages.getString("MergeSchemasSelectionWizardPage.SelectElements"));
        projectsLabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.projectsTreeViewer = new CheckboxTreeViewer(new Tree(composite, 67616));
        GridData projectsTableViewerGridData = new GridData(4, 4, true, true, 1, 1);
        projectsTableViewerGridData.widthHint = 450;
        projectsTableViewerGridData.heightHint = 250;
        this.projectsTreeViewer.getTree().setLayoutData((Object)projectsTableViewerGridData);
        this.projectsTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof List) {
                    return ((List)parentElement).toArray();
                }
                if (parentElement instanceof Project) {
                    Project project = (Project)parentElement;
                    List<Schema> schemas = project.getSchemaHandler().getSchemas();
                    return schemas.toArray();
                }
                if (parentElement instanceof Schema) {
                    Schema schema = (Schema)parentElement;
                    Object[] children = new Object[]{new AttributeTypeFolder(schema), new ObjectClassFolder(schema)};
                    return children;
                }
                if (parentElement instanceof AttributeTypeFolder) {
                    AttributeTypeFolder folder = (AttributeTypeFolder)parentElement;
                    List<AttributeTypeImpl> attributeTypes = folder.schema.getAttributeTypes();
                    return attributeTypes.toArray();
                }
                if (parentElement instanceof ObjectClassFolder) {
                    ObjectClassFolder folder = (ObjectClassFolder)parentElement;
                    List<ObjectClassImpl> objectClasses = folder.schema.getObjectClasses();
                    return objectClasses.toArray();
                }
                return new Object[0];
            }
        });
        this.projectsTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Project) {
                    return ((Project)element).getName();
                }
                if (element instanceof Schema) {
                    return ((Schema)element).getName();
                }
                if (element instanceof ObjectClassFolder) {
                    return Messages.getString("MergeSchemasSelectionWizardPage.ObjectClasses");
                }
                if (element instanceof AttributeTypeFolder) {
                    return Messages.getString("MergeSchemasSelectionWizardPage.AttributeTypes");
                }
                if (element instanceof AttributeType) {
                    AttributeType at = (AttributeType)element;
                    String[] names = at.getNamesRef();
                    if (names != null && names.length > 0) {
                        return names[0];
                    }
                    return at.getOid();
                }
                if (element instanceof ObjectClass) {
                    ObjectClass oc = (ObjectClass)element;
                    String[] names = oc.getNamesRef();
                    if (names != null && names.length > 0) {
                        return names[0];
                    }
                    return oc.getOid();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Project) {
                    ProjectType type = ((Project)element).getType();
                    switch (type) {
                        case OFFLINE: {
                            return Activator.getDefault().getImage("resources/icons/project_offline_closed.gif");
                        }
                        case ONLINE: {
                            return Activator.getDefault().getImage("resources/icons/project_online_closed.gif");
                        }
                    }
                } else {
                    if (element instanceof Schema) {
                        return Activator.getDefault().getImage("resources/icons/schema.gif");
                    }
                    if (element instanceof ObjectClassFolder) {
                        return Activator.getDefault().getImage("resources/icons/folder_oc.gif");
                    }
                    if (element instanceof AttributeTypeFolder) {
                        return Activator.getDefault().getImage("resources/icons/folder_at.gif");
                    }
                    if (element instanceof AttributeType) {
                        return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
                    }
                    if (element instanceof ObjectClass) {
                        return Activator.getDefault().getImage("resources/icons/object_class.gif");
                    }
                }
                return super.getImage(element);
            }
        });
        this.projectsTreeViewer.setSorter(new ViewerSorter());
        this.projectsTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MergeSchemasSelectionWizardPage.this.dialogChanged();
            }
        });
        this.initFields();
        this.setControl((Control)composite);
    }

    private void initFields() {
        ArrayList<Project> projects = new ArrayList<Project>();
        projects.addAll(Activator.getDefault().getProjectsHandler().getProjects());
        Collections.sort(projects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.projectsTreeViewer.setInput(projects);
        this.projectsTreeViewer.setCheckedElements((Object[])this.selectedProjects);
        this.displayErrorMessage(null);
        this.setPageComplete(false);
    }

    private void dialogChanged() {
        if (this.projectsTreeViewer.getCheckedElements().length == 0) {
            this.displayErrorMessage(Messages.getString("MergeSchemasSelectionWizardPage.ErrorNoElementsSelected"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public Object[] getSelectedObjects() {
        Object[] selectedObjects = this.projectsTreeViewer.getCheckedElements();
        return selectedObjects;
    }

    public void setSelectedProjects(Project[] projects) {
        this.selectedProjects = projects;
    }

    class AttributeTypeFolder {
        Schema schema;

        public AttributeTypeFolder(Schema schema) {
            this.schema = schema;
        }
    }

    class ObjectClassFolder {
        Schema schema;

        public ObjectClassFolder(Schema schema) {
            this.schema = schema;
        }
    }
}

