/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgressAdapter;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileImportException;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileImporter;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaChecker;
import org.apache.directory.studio.schemaeditor.view.wizards.ImportSchemasFromOpenLdapWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportSchemasFromOpenLdapWizard
extends Wizard
implements IImportWizard {
    private SchemaHandler schemaHandler;
    private SchemaChecker schemaChecker;
    private ImportSchemasFromOpenLdapWizardPage page;

    public void addPages() {
        this.page = new ImportSchemasFromOpenLdapWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        final File[] selectedSchemasFiles = this.page.getSelectedSchemaFiles();
        this.schemaChecker.disableModificationsListening();
        StudioRunnableWithProgressAdapter runnable = new StudioRunnableWithProgressAdapter(){

            public void run(StudioProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("ImportSchemasFromOpenLdapWizard.ImportingSchemas"), selectedSchemasFiles.length);
                for (File schemaFile : selectedSchemasFiles) {
                    monitor.subTask(schemaFile.getName());
                    try {
                        Schema schema = OpenLdapSchemaFileImporter.getSchema(new FileInputStream(schemaFile), schemaFile.getAbsolutePath());
                        schema.setProject(Activator.getDefault().getProjectsHandler().getOpenProject());
                        ImportSchemasFromOpenLdapWizard.this.schemaHandler.addSchema(schema);
                    }
                    catch (OpenLdapSchemaFileImportException e) {
                        this.reportError(e, schemaFile, monitor);
                    }
                    catch (FileNotFoundException e) {
                        this.reportError(e, schemaFile, monitor);
                    }
                    monitor.worked(1);
                }
            }

            private void reportError(Exception e, File schemaFile, StudioProgressMonitor monitor) {
                String message = NLS.bind((String)Messages.getString("ImportSchemasFromOpenLdapWizard.ErrorImportingSchema"), (Object)schemaFile.getName());
                monitor.reportError(message, e);
            }

            public String getName() {
                return Messages.getString("ImportSchemasFromOpenLdapWizard.ImportingSchemas");
            }
        };
        RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, (IRunnableContext)this.getContainer(), (boolean)true);
        this.schemaChecker.enableModificationsListening();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
        this.schemaChecker = Activator.getDefault().getSchemaChecker();
    }
}

