/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.widget.CoreSchemasSelectionWidget;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ImportCoreSchemasWizardPage
extends AbstractWizardPage {
    private CoreSchemasSelectionWidget coreSchemaSelectionWidget;

    protected ImportCoreSchemasWizardPage() {
        super("ImportCoreSchemasWizardPage");
        this.setTitle(Messages.getString("ImportCoreSchemasWizardPage.ImportCoreSchemas"));
        this.setDescription(Messages.getString("ImportCoreSchemasWizardPage.PleaseSelectCoreSchemas"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/schemas_import_wizard.png"));
    }

    public void createControl(Composite parent) {
        this.coreSchemaSelectionWidget = new CoreSchemasSelectionWidget();
        Composite composite = this.coreSchemaSelectionWidget.createWidget(parent);
        this.coreSchemaSelectionWidget.init(CoreSchemasSelectionWidget.ServerTypeEnum.APACHE_DS);
        Project project = Activator.getDefault().getProjectsHandler().getOpenProject();
        if (project != null) {
            List<Schema> schemas = project.getSchemaHandler().getSchemas();
            ArrayList<String> schemaNames = new ArrayList<String>();
            for (Schema schema : schemas) {
                schemaNames.add(schema.getName());
            }
            this.coreSchemaSelectionWidget.setGrayedCoreSchemas(schemaNames.toArray(new String[0]));
        }
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    private void dialogChanged() {
        if (Activator.getDefault().getSchemaHandler() == null) {
            this.displayErrorMessage(Messages.getString("ImportCoreSchemasWizardPage.ErrorNoSchemaProjectOpen"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public String[] getSelectedSchemas() {
        return this.coreSchemaSelectionWidget.getSelectedCoreSchemas();
    }

    public CoreSchemasSelectionWidget.ServerTypeEnum getServerType() {
        return this.coreSchemaSelectionWidget.getServerType();
    }
}

