/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.converter.schema.AttributeTypeHolder;
import org.apache.directory.shared.converter.schema.ObjectClassHolder;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.wizards.ExportSchemasForADSWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportSchemasForADSWizard
extends Wizard
implements IExportWizard {
    private Schema[] selectedSchemas = new Schema[0];
    private ExportSchemasForADSWizardPage page;

    public void addPages() {
        this.page = new ExportSchemasForADSWizardPage();
        this.page.setSelectedSchemas(this.selectedSchemas);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        final Schema[] selectedSchemas = this.page.getSelectedSchemas();
        int exportType = this.page.getExportType();
        if (exportType == 0) {
            final String exportDirectory = this.page.getExportDirectory();
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString("ExportSchemasForADSWizard.ExportingSchemas"), selectedSchemas.length);
                        for (Schema schema : selectedSchemas) {
                            monitor.subTask(schema.getName());
                            StringBuffer sb = new StringBuffer();
                            DateFormat format = DateFormat.getDateTimeInstance(1, 2);
                            Date date = new Date();
                            sb.append(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.GeneratedByApacheComment"), (Object[])new String[]{format.format(date)}));
                            try {
                                ExportSchemasForADSWizard.this.toLdif(schema, sb);
                                BufferedWriter buffWriter = new BufferedWriter(new FileWriter(exportDirectory + "/" + schema.getName() + ".ldif"));
                                buffWriter.write(sb.toString());
                                buffWriter.close();
                            }
                            catch (IOException e) {
                                PluginUtils.logError(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}), e);
                                ViewUtils.displayErrorMessageBox(Messages.getString("ExportSchemasForADSWizard.Error"), NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}));
                            }
                            catch (NamingException e) {
                                PluginUtils.logError(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}), e);
                                ViewUtils.displayErrorMessageBox(Messages.getString("ExportSchemasForADSWizard.Error"), NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}));
                            }
                            monitor.worked(1);
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
            }
            catch (InterruptedException e) {}
        } else if (exportType == 1) {
            final String exportFile = this.page.getExportFile();
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString("ExportSchemasForADSWizard.ExportingSchemas"), 1);
                        StringBuffer sb = new StringBuffer();
                        DateFormat format = DateFormat.getDateTimeInstance(1, 2);
                        Date date = new Date();
                        sb.append(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.GeneratedByApacheComment"), (Object[])new String[]{format.format(date)}));
                        for (Schema schema : selectedSchemas) {
                            try {
                                ExportSchemasForADSWizard.this.toLdif(schema, sb);
                            }
                            catch (NamingException e) {
                                PluginUtils.logError(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}), e);
                                ViewUtils.displayErrorMessageBox(Messages.getString("ExportSchemasForADSWizard.Error"), NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}));
                            }
                        }
                        try {
                            BufferedWriter buffWriter = new BufferedWriter(new FileWriter(exportFile));
                            buffWriter.write(sb.toString());
                            buffWriter.close();
                        }
                        catch (IOException e) {
                            PluginUtils.logError(Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchemas"), e);
                            ViewUtils.displayErrorMessageBox(Messages.getString("ExportSchemasForADSWizard.Error"), Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchemas"));
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return true;
    }

    private void toLdif(Schema schema, StringBuffer sb) throws NamingException {
        String[] schemaDependencies;
        sb.append(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.SchemaComment"), (Object[])new String[]{schema.getName().toUpperCase()}));
        sb.append("dn: cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: metaSchema\n");
        sb.append("objectclass: top\n");
        sb.append("cn: " + schema.getName() + "\n");
        for (String schemaName : schemaDependencies = this.getSchemaDependencies(schema)) {
            sb.append("m-dependencies: " + schemaName + "\n");
        }
        sb.append("\n");
        sb.append("dn: ou=attributeTypes, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: attributetypes\n");
        sb.append("\n");
        for (AttributeTypeImpl at : schema.getAttributeTypes()) {
            AttributeTypeHolder holder = new AttributeTypeHolder(at.getOid());
            holder.setCollective(at.isCollective());
            holder.setDescription(at.getDescription());
            holder.setEquality(at.getEqualityName());
            ArrayList<String> names = new ArrayList<String>();
            for (String name : at.getNamesRef()) {
                names.add(name);
            }
            holder.setNames(names);
            holder.setNoUserModification(!at.isCanUserModify());
            holder.setObsolete(at.isObsolete());
            holder.setOrdering(at.getOrderingName());
            holder.setSingleValue(at.isSingleValue());
            holder.setSubstr(at.getSubstrName());
            holder.setSuperior(at.getSuperiorName());
            holder.setSyntax(at.getSyntaxOid());
            holder.setOidLen(at.getLength());
            holder.setUsage(at.getUsage());
            sb.append(holder.toLdif(schema.getName()) + "\n");
        }
        sb.append("dn: ou=comparators, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: comparators\n");
        sb.append("\n");
        sb.append("dn: ou=ditContentRules, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: ditcontentrules\n");
        sb.append("\n");
        sb.append("dn: ou=ditStructureRules, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: ditstructurerules\n");
        sb.append("\n");
        sb.append("dn: ou=matchingRules, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: matchingrules\n");
        sb.append("\n");
        sb.append("dn: ou=matchingRuleUse, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: matchingruleuse\n");
        sb.append("\n");
        sb.append("dn: ou=nameForms, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: nameforms\n");
        sb.append("\n");
        sb.append("dn: ou=normalizers, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: normalizers\n");
        sb.append("\n");
        sb.append("dn: ou=objectClasses, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: objectClasses\n");
        sb.append("\n");
        List<ObjectClassImpl> sortedObjectClasses = this.getSortedObjectClasses(schema.getObjectClasses());
        for (ObjectClassImpl oc : sortedObjectClasses) {
            ObjectClassHolder holder = new ObjectClassHolder(oc.getOid());
            holder.setClassType(oc.getType());
            holder.setDescription(oc.getDescription());
            ArrayList<String> mayList = new ArrayList<String>();
            for (String may : oc.getMayNamesList()) {
                mayList.add(may);
            }
            holder.setMay(mayList);
            ArrayList<String> mustList = new ArrayList<String>();
            for (String must : oc.getMustNamesList()) {
                mustList.add(must);
            }
            holder.setMust(mustList);
            ArrayList<String> names = new ArrayList<String>();
            for (String name : oc.getNamesRef()) {
                names.add(name);
            }
            holder.setNames(names);
            ArrayList<String> superiorList = new ArrayList<String>();
            for (String superior : oc.getSuperClassesNames()) {
                superiorList.add(superior);
            }
            holder.setSuperiors(superiorList);
            holder.setObsolete(oc.isObsolete());
            sb.append(holder.toLdif(schema.getName()) + "\n");
        }
        sb.append("dn: ou=syntaxCheckers, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: syntaxcheckers\n");
        sb.append("\n");
        sb.append("dn: ou=syntaxes, cn=" + schema.getName() + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: syntaxes\n");
        sb.append("\n");
    }

    private List<ObjectClassImpl> getSortedObjectClasses(List<ObjectClassImpl> objectClasses) {
        ArrayList<ObjectClassImpl> unsortedObjectClasses = new ArrayList<ObjectClassImpl>(objectClasses);
        HashSet<String> objectClassNames = new HashSet<String>();
        for (ObjectClassImpl oc : unsortedObjectClasses) {
            for (String name : oc.getNamesRef()) {
                objectClassNames.add(name.toLowerCase());
            }
        }
        ArrayList<ObjectClassImpl> sortedObjectClasses = new ArrayList<ObjectClassImpl>();
        HashSet<String> movedObjectClasses = new HashSet<String>();
        boolean moved = true;
        while (!unsortedObjectClasses.isEmpty() && moved) {
            moved = false;
            Iterator unsortedIterator = unsortedObjectClasses.iterator();
            block3: while (unsortedIterator.hasNext()) {
                ObjectClassImpl oc = (ObjectClassImpl)((Object)unsortedIterator.next());
                for (String superName : oc.getSuperClassesNames()) {
                    if (objectClassNames.contains(superName.toLowerCase()) && !movedObjectClasses.contains(superName.toLowerCase())) continue;
                    unsortedIterator.remove();
                    sortedObjectClasses.add(oc);
                    for (String name : oc.getNamesRef()) {
                        movedObjectClasses.add(name.toLowerCase());
                    }
                    moved = true;
                    continue block3;
                }
            }
        }
        for (ObjectClassImpl oc : unsortedObjectClasses) {
            sortedObjectClasses.add(oc);
        }
        return sortedObjectClasses;
    }

    private String[] getSchemaDependencies(Schema schema) {
        HashSet<String> schemaNames = new HashSet<String>();
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        for (AttributeTypeImpl at : schema.getAttributeTypes()) {
            AttributeTypeImpl sup;
            String supName = at.getSuperiorName();
            if (supName == null || (sup = schemaHandler.getAttributeType(supName)) == null || schema.getName().toLowerCase().equals(sup.getSchema().toLowerCase())) continue;
            schemaNames.add(sup.getSchema());
        }
        for (ObjectClassImpl oc : schema.getObjectClasses()) {
            String[] mustNames;
            String[] mayNames;
            String[] supNames = oc.getSuperClassesNames();
            if (supNames != null) {
                for (String supName : oc.getSuperClassesNames()) {
                    ObjectClassImpl sup = schemaHandler.getObjectClass(supName);
                    if (sup == null || schema.getName().toLowerCase().equals(sup.getSchema().toLowerCase())) continue;
                    schemaNames.add(sup.getSchema());
                }
            }
            if ((mayNames = oc.getMayNamesList()) != null) {
                for (String mayName : mayNames) {
                    AttributeTypeImpl may = schemaHandler.getAttributeType(mayName);
                    if (may == null || schema.getName().toLowerCase().equals(may.getSchema().toLowerCase())) continue;
                    schemaNames.add(may.getSchema());
                }
            }
            if ((mustNames = oc.getMustNamesList()) == null) continue;
            for (String mustName : oc.getMustNamesList()) {
                AttributeTypeImpl must = schemaHandler.getAttributeType(mustName);
                if (must == null || schema.getName().toLowerCase().equals(must.getSchema().toLowerCase())) continue;
                schemaNames.add(must.getSchema());
            }
        }
        return schemaNames.toArray(new String[0]);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void setSelectedSchemas(Schema[] schemas) {
        this.selectedSchemas = schemas;
    }
}

