/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileExporter;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.wizards.ExportSchemasAsOpenLdapWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportSchemasAsOpenLdapWizard
extends Wizard
implements IExportWizard {
    private Schema[] selectedSchemas = new Schema[0];
    private ExportSchemasAsOpenLdapWizardPage page;

    public void addPages() {
        this.page = new ExportSchemasAsOpenLdapWizardPage();
        this.page.setSelectedSchemas(this.selectedSchemas);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        final Schema[] selectedSchemas = this.page.getSelectedSchemas();
        final String exportDirectory = this.page.getExportDirectory();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString("ExportSchemasAsOpenLdapWizard.ExportingSchemas"), selectedSchemas.length);
                    for (Schema schema : selectedSchemas) {
                        monitor.subTask(schema.getName());
                        try {
                            BufferedWriter buffWriter = new BufferedWriter(new FileWriter(exportDirectory + "/" + schema.getName() + ".schema"));
                            buffWriter.write(OpenLdapSchemaFileExporter.toSourceCode(schema));
                            buffWriter.close();
                        }
                        catch (IOException e) {
                            PluginUtils.logError(NLS.bind((String)Messages.getString("ExportSchemasAsOpenLdapWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}), e);
                            ViewUtils.displayErrorMessageBox(Messages.getString("ExportSchemasAsOpenLdapWizard.Error"), NLS.bind((String)Messages.getString("ExportSchemasAsOpenLdapWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getName()}));
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void setSelectedSchemas(Schema[] schemas) {
        this.selectedSchemas = schemas;
    }
}

