/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.io.ProjectsExporter;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.wizards.ExportProjectsWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportProjectsWizard
extends Wizard
implements IExportWizard {
    private Project[] selectedProjects = new Project[0];
    private ExportProjectsWizardPage page;

    public void addPages() {
        this.page = new ExportProjectsWizardPage();
        this.page.setSelectedProjects(this.selectedProjects);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        final Project[] selectedProjects = this.page.getSelectedProjects();
        final String exportDirectory = this.page.getExportDirectory();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString("ExportProjectsWizard.ExportingProject"), selectedProjects.length);
                    for (Project project : selectedProjects) {
                        monitor.subTask(project.getName());
                        try {
                            OutputFormat outformat = OutputFormat.createPrettyPrint();
                            outformat.setEncoding("UTF-8");
                            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(exportDirectory + "/" + project.getName() + ".schemaproject"), outformat);
                            writer.write(ProjectsExporter.toDocument(project));
                            writer.flush();
                        }
                        catch (UnsupportedEncodingException e) {
                            PluginUtils.logError(NLS.bind((String)Messages.getString("ExportProjectsWizard.ErrorWhenSavingProject"), (Object[])new String[]{project.getName()}), e);
                            ViewUtils.displayErrorMessageBox(Messages.getString("ExportProjectsWizard.Error"), NLS.bind((String)Messages.getString("ExportProjectsWizard.ErrorWhenSavingProject"), (Object[])new String[]{project.getName()}));
                        }
                        catch (FileNotFoundException e) {
                            PluginUtils.logError(NLS.bind((String)Messages.getString("ExportProjectsWizard.ErrorWhenSavingProject"), (Object[])new String[]{project.getName()}), e);
                            ViewUtils.displayErrorMessageBox(Messages.getString("ExportProjectsWizard.Error"), NLS.bind((String)Messages.getString("ExportProjectsWizard.ErrorWhenSavingProject"), (Object[])new String[]{project.getName()}));
                        }
                        catch (IOException e) {
                            PluginUtils.logError(NLS.bind((String)Messages.getString("ExportProjectsWizard.ErrorWhenSavingProject"), (Object[])new String[]{project.getName()}), e);
                            ViewUtils.displayErrorMessageBox(Messages.getString("ExportProjectsWizard.Error"), NLS.bind((String)Messages.getString("ExportProjectsWizard.ErrorWhenSavingProject"), (Object[])new String[]{project.getName()}));
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void setSelectedProjects(Project[] projects) {
        this.selectedProjects = projects;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

