/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.directory.studio.schemaeditor.model.difference.Difference;
import org.apache.directory.studio.schemaeditor.view.widget.Messages;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folder {
    protected List<Difference> children;
    private FolderType type = FolderType.NONE;
    private String name = "";

    public Folder(FolderType type) {
        this.type = type;
        switch (type) {
            case ATTRIBUTE_TYPE: {
                this.name = Messages.getString("Folder.AttributeTypes");
                break;
            }
            case OBJECT_CLASS: {
                this.name = Messages.getString("Folder.ObjectClasses");
            }
        }
    }

    public FolderType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return !this.children.isEmpty();
    }

    public List<Difference> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Difference>();
        }
        return this.children;
    }

    public void addChild(Difference diff) {
        if (this.children == null) {
            this.children = new ArrayList<Difference>();
        }
        if (!this.children.contains(diff)) {
            this.children.add(diff);
        }
    }

    public void removeChild(TreeNode node) {
        if (this.children != null) {
            this.children.remove(node);
        }
    }

    public boolean addAllChildren(Collection<? extends Difference> c) {
        if (this.children == null) {
            this.children = new ArrayList<Difference>();
        }
        return this.children.addAll(c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FolderType {
        NONE,
        ATTRIBUTE_TYPE,
        OBJECT_CLASS,
        ERROR,
        WARNING;

    }
}

