/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.widget;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.difference.AttributeTypeDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ObjectClassDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SchemaDifference;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.widget.Folder;
import org.apache.directory.studio.schemaeditor.view.widget.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DifferencesWidgetSchemaLabelProvider
extends LabelProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public String getText(Object element) {
        String[] names;
        String label = "";
        int labelValue = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_LABEL);
        boolean abbreviate = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE);
        int abbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE_MAX_LENGTH);
        boolean secondaryLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_DISPLAY);
        int secondaryLabelValue = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL);
        boolean secondaryLabelAbbreviate = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE);
        int secondaryLabelAbbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        if (element instanceof SchemaDifference) {
            SchemaDifference sd = (SchemaDifference)element;
            switch (sd.getType()) {
                case ADDED: {
                    return ((Schema)sd.getDestination()).getName();
                }
                case MODIFIED: {
                    return ((Schema)sd.getDestination()).getName();
                }
                case REMOVED: {
                    return ((Schema)sd.getSource()).getName();
                }
                case IDENTICAL: {
                    return ((Schema)sd.getDestination()).getName();
                }
            }
        } else if (element instanceof AttributeTypeDifference) {
            AttributeTypeDifference atd = (AttributeTypeDifference)element;
            AttributeTypeImpl at = null;
            switch (atd.getType()) {
                case ADDED: {
                    at = (AttributeTypeImpl)((Object)atd.getDestination());
                    break;
                }
                case MODIFIED: {
                    at = (AttributeTypeImpl)((Object)atd.getDestination());
                    break;
                }
                case REMOVED: {
                    at = (AttributeTypeImpl)((Object)atd.getSource());
                    break;
                }
                case IDENTICAL: {
                    at = (AttributeTypeImpl)((Object)atd.getDestination());
                }
            }
            label = labelValue == 0 ? ((names = at.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 1 ? ((names = at.getNamesRef()) != null && names.length > 0 ? ViewUtils.concateAliases(names) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 2 ? at.getOid() : ((names = at.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("DifferencesWidgetSchemaLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        } else if (element instanceof ObjectClassDifference) {
            ObjectClassDifference ocd = (ObjectClassDifference)element;
            ObjectClassImpl oc = null;
            switch (ocd.getType()) {
                case ADDED: {
                    oc = (ObjectClassImpl)((Object)ocd.getDestination());
                    break;
                }
                case MODIFIED: {
                    oc = (ObjectClassImpl)((Object)ocd.getDestination());
                    break;
                }
                case REMOVED: {
                    oc = (ObjectClassImpl)((Object)ocd.getSource());
                    break;
                }
                case IDENTICAL: {
                    oc = (ObjectClassImpl)((Object)ocd.getDestination());
                }
            }
            label = labelValue == 0 ? ((names = oc.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 1 ? ((names = oc.getNamesRef()) != null && names.length > 0 ? ViewUtils.concateAliases(names) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 2 ? oc.getOid() : ((names = oc.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("DifferencesWidgetSchemaLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            return folder.getName() + " (" + folder.getChildren().size() + ")";
        }
        if (secondaryLabelDisplay) {
            String secondaryLabel = "";
            if (element instanceof AttributeTypeDifference) {
                AttributeTypeDifference atd = (AttributeTypeDifference)element;
                AttributeTypeImpl at = null;
                switch (atd.getType()) {
                    case ADDED: {
                        at = (AttributeTypeImpl)((Object)atd.getDestination());
                        break;
                    }
                    case MODIFIED: {
                        at = (AttributeTypeImpl)((Object)atd.getDestination());
                        break;
                    }
                    case REMOVED: {
                        at = (AttributeTypeImpl)((Object)atd.getSource());
                        break;
                    }
                    case IDENTICAL: {
                        at = (AttributeTypeImpl)((Object)atd.getDestination());
                    }
                }
                if (secondaryLabelValue == 0) {
                    String[] names2 = at.getNamesRef();
                    secondaryLabel = names2 != null && names2.length > 0 ? names2[0] : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    String[] names3 = at.getNamesRef();
                    secondaryLabel = names3 != null && names3.length > 0 ? ViewUtils.concateAliases(names3) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = at.getOid();
                }
            } else if (element instanceof ObjectClassDifference) {
                ObjectClassDifference ocd = (ObjectClassDifference)element;
                ObjectClassImpl oc = null;
                switch (ocd.getType()) {
                    case ADDED: {
                        oc = (ObjectClassImpl)((Object)ocd.getDestination());
                        break;
                    }
                    case MODIFIED: {
                        oc = (ObjectClassImpl)((Object)ocd.getDestination());
                        break;
                    }
                    case REMOVED: {
                        oc = (ObjectClassImpl)((Object)ocd.getSource());
                        break;
                    }
                    case IDENTICAL: {
                        oc = (ObjectClassImpl)((Object)ocd.getDestination());
                    }
                }
                if (secondaryLabelValue == 0) {
                    String[] names4 = oc.getNamesRef();
                    secondaryLabel = names4 != null && names4.length > 0 ? names4[0] : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    String[] names5 = oc.getNamesRef();
                    secondaryLabel = names5 != null && names5.length > 0 ? ViewUtils.concateAliases(names5) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = oc.getOid();
                }
            }
            if (secondaryLabelAbbreviate && secondaryLabelAbbreviateMaxLength < secondaryLabel.length()) {
                secondaryLabel = secondaryLabel.substring(0, secondaryLabelAbbreviateMaxLength) + "...";
            }
            label = label + "  [" + secondaryLabel + "]";
        }
        return label;
    }

    public Image getImage(Object element) {
        if (element instanceof SchemaDifference) {
            SchemaDifference sd = (SchemaDifference)element;
            switch (sd.getType()) {
                case ADDED: {
                    return Activator.getDefault().getImage("resources/icons/difference_schema_add.gif");
                }
                case MODIFIED: {
                    return Activator.getDefault().getImage("resources/icons/difference_schema_modify.gif");
                }
                case REMOVED: {
                    return Activator.getDefault().getImage("resources/icons/difference_schema_remove.gif");
                }
                case IDENTICAL: {
                    return Activator.getDefault().getImage("resources/icons/schema.gif");
                }
            }
        } else if (element instanceof AttributeTypeDifference) {
            AttributeTypeDifference atd = (AttributeTypeDifference)element;
            switch (atd.getType()) {
                case ADDED: {
                    return Activator.getDefault().getImage("resources/icons/difference_attribute_type_add.gif");
                }
                case MODIFIED: {
                    return Activator.getDefault().getImage("resources/icons/difference_attribute_type_modify.gif");
                }
                case REMOVED: {
                    return Activator.getDefault().getImage("resources/icons/difference_attribute_type_remove.gif");
                }
                case IDENTICAL: {
                    return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
                }
            }
        } else if (element instanceof ObjectClassDifference) {
            ObjectClassDifference ocd = (ObjectClassDifference)element;
            switch (ocd.getType()) {
                case ADDED: {
                    return Activator.getDefault().getImage("resources/icons/difference_object_class_add.gif");
                }
                case MODIFIED: {
                    return Activator.getDefault().getImage("resources/icons/difference_object_class_modify.gif");
                }
                case REMOVED: {
                    return Activator.getDefault().getImage("resources/icons/difference_object_class_remove.gif");
                }
                case IDENTICAL: {
                    return Activator.getDefault().getImage("resources/icons/object_class.gif");
                }
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            switch (folder.getType()) {
                case ATTRIBUTE_TYPE: {
                    return Activator.getDefault().getImage("resources/icons/folder_at.gif");
                }
                case OBJECT_CLASS: {
                    return Activator.getDefault().getImage("resources/icons/folder_oc.gif");
                }
                case NONE: {
                    return Activator.getDefault().getImage("resources/icons/folder.gif");
                }
            }
        }
        return null;
    }
}

