/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.widget;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenSchemaViewPreferenceAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenSchemaViewSortingDialogAction;
import org.apache.directory.studio.schemaeditor.model.difference.AttributeTypeDifference;
import org.apache.directory.studio.schemaeditor.model.difference.DifferenceType;
import org.apache.directory.studio.schemaeditor.model.difference.ObjectClassDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SchemaDifference;
import org.apache.directory.studio.schemaeditor.view.widget.DifferencesWidgetPropertiesContentProvider;
import org.apache.directory.studio.schemaeditor.view.widget.DifferencesWidgetPropertiesLabelProvider;
import org.apache.directory.studio.schemaeditor.view.widget.DifferencesWidgetSchemaContentProvider;
import org.apache.directory.studio.schemaeditor.view.widget.DifferencesWidgetSchemaLabelProvider;
import org.apache.directory.studio.schemaeditor.view.widget.Folder;
import org.apache.directory.studio.schemaeditor.view.widget.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferencesWidget {
    private IPreferenceStore store;
    private List<String> authorizedPrefs;
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (DifferencesWidget.this.authorizedPrefs.contains(event.getProperty())) {
                DifferencesWidget.this.treeViewer.refresh();
            }
        }
    };
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private MenuItem groupByType;
    private MenuItem groupByProperty;

    public DifferencesWidget() {
        this.store = Activator.getDefault().getPreferenceStore();
    }

    public void createWidget(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final ToolBar leftToolBar = new ToolBar(leftComposite, 0x800100);
        leftToolBar.setLayoutData((Object)new GridData(131072, 0, false, false));
        final ToolItem leftMenuToolItem = new ToolItem(leftToolBar, 8);
        leftMenuToolItem.setImage(Activator.getDefault().getImage("resources/icons/toolbar_menu.gif"));
        leftMenuToolItem.setToolTipText(Messages.getString("DifferencesWidget.MenuToolTip"));
        final Menu leftMenu = new Menu((Decorations)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8);
        leftMenuToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = leftMenuToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = leftToolBar.toDisplay(pt);
                leftMenu.setLocation(pt.x, pt.y);
                leftMenu.setVisible(true);
            }
        });
        MenuItem sortingMenuItem = new MenuItem(leftMenu, 8);
        sortingMenuItem.setText(Messages.getString("DifferencesWidget.Sorting"));
        sortingMenuItem.setImage(Activator.getDefault().getImage("resources/icons/sorting.gif"));
        sortingMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new OpenSchemaViewSortingDialogAction().run();
            }
        });
        new MenuItem(leftMenu, 2);
        MenuItem preferencesMenuItem = new MenuItem(leftMenu, 8);
        preferencesMenuItem.setText(Messages.getString("DifferencesWidget.Preferences"));
        preferencesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new OpenSchemaViewPreferenceAction().run();
            }
        });
        this.treeViewer = new TreeViewer(leftComposite, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.treeViewer.setContentProvider((IContentProvider)new DifferencesWidgetSchemaContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DifferencesWidgetSchemaLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObjectClassDifference ocd;
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof AttributeTypeDifference) {
                    AttributeTypeDifference atd = (AttributeTypeDifference)element;
                    if (atd.getType().equals((Object)DifferenceType.MODIFIED)) {
                        DifferencesWidget.this.tableViewer.setInput(atd.getDifferences());
                        return;
                    }
                } else if (element instanceof ObjectClassDifference && (ocd = (ObjectClassDifference)element).getType().equals((Object)DifferenceType.MODIFIED)) {
                    DifferencesWidget.this.tableViewer.setInput(ocd.getDifferences());
                    return;
                }
                DifferencesWidget.this.tableViewer.setInput(null);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof Folder || element instanceof SchemaDifference) {
                    DifferencesWidget.this.treeViewer.setExpandedState(element, !DifferencesWidget.this.treeViewer.getExpandedState(element));
                }
            }
        });
        Composite rightComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final ToolBar rightToolBar = new ToolBar(rightComposite, 0x800100);
        rightToolBar.setLayoutData((Object)new GridData(131072, 0, false, false));
        final ToolItem rightMenuToolItem = new ToolItem(rightToolBar, 8);
        rightMenuToolItem.setImage(Activator.getDefault().getImage("resources/icons/toolbar_menu.gif"));
        rightMenuToolItem.setToolTipText(Messages.getString("DifferencesWidget.MenuToolTip"));
        final Menu rightMenu = new Menu((Decorations)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8);
        rightMenuToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = rightMenuToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = rightToolBar.toDisplay(pt);
                rightMenu.setLocation(pt.x, pt.y);
                rightMenu.setVisible(true);
            }
        });
        this.groupByProperty = new MenuItem(rightMenu, 32);
        this.groupByProperty.setText(Messages.getString("DifferencesWidget.GroupByProperty"));
        this.groupByProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DifferencesWidget.this.changeGrouping(0);
            }
        });
        this.groupByType = new MenuItem(rightMenu, 32);
        this.groupByType.setText(Messages.getString("DifferencesWidget.GroupByType"));
        this.groupByType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DifferencesWidget.this.changeGrouping(1);
            }
        });
        this.updateMenuItemsCheckStatus();
        this.tableViewer = new TableViewer(rightComposite, 2820);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.setContentProvider((IContentProvider)new DifferencesWidgetPropertiesContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DifferencesWidgetPropertiesLabelProvider());
        this.initAuthorizedPrefs();
        this.initPreferencesListener();
    }

    public void setInput(List<SchemaDifference> input) {
        this.treeViewer.setInput(input);
    }

    private void changeGrouping(int value) {
        this.store.setValue(PluginConstants.PREFS_DIFFERENCES_WIDGET_GROUPING, value);
        this.updateMenuItemsCheckStatus();
        this.tableViewer.refresh();
    }

    private void updateMenuItemsCheckStatus() {
        int prefValue = this.store.getInt(PluginConstants.PREFS_DIFFERENCES_WIDGET_GROUPING);
        if (prefValue == 0) {
            this.groupByProperty.setSelection(true);
            this.groupByType.setSelection(false);
        } else if (prefValue == 1) {
            this.groupByProperty.setSelection(false);
            this.groupByType.setSelection(true);
        } else {
            this.groupByProperty.setSelection(false);
            this.groupByType.setSelection(false);
        }
    }

    private void initAuthorizedPrefs() {
        this.authorizedPrefs = new ArrayList<String>();
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE_MAX_LENGTH);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_DISPLAY);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_BY);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_ORDER);
    }

    private void initPreferencesListener() {
        this.store.addPropertyChangeListener(this.preferenceListener);
    }

    public void dispose() {
        this.store.removePropertyChangeListener(this.preferenceListener);
    }
}

