/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SearchViewLabelProvider
extends LabelProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public String getText(Object element) {
        String[] names;
        String label = "";
        int labelValue = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_LABEL);
        boolean abbreviate = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE);
        int abbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE_MAX_LENGTH);
        boolean secondaryLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_DISPLAY);
        int secondaryLabelValue = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL);
        boolean secondaryLabelAbbreviate = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE);
        int secondaryLabelAbbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        boolean schemaLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SCHEMA_LABEL_DISPLAY);
        if (element instanceof AttributeTypeImpl) {
            AttributeTypeImpl at = (AttributeTypeImpl)((Object)element);
            label = labelValue == 0 ? ((names = at.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 1 ? ((names = at.getNamesRef()) != null && names.length > 0 ? ViewUtils.concateAliases(names) : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 2 ? at.getOid() : ((names = at.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("SearchViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        } else if (element instanceof ObjectClassImpl) {
            ObjectClassImpl oc = (ObjectClassImpl)((Object)element);
            label = labelValue == 0 ? ((names = oc.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 1 ? ((names = oc.getNamesRef()) != null && names.length > 0 ? ViewUtils.concateAliases(names) : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 2 ? oc.getOid() : ((names = oc.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("SearchViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        }
        if (secondaryLabelDisplay) {
            String secondaryLabel = "";
            if (element instanceof AttributeTypeImpl) {
                AttributeTypeImpl at = (AttributeTypeImpl)((Object)element);
                if (secondaryLabelValue == 0) {
                    String[] names2 = at.getNamesRef();
                    secondaryLabel = names2 != null && names2.length > 0 ? names2[0] : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    String[] names3 = at.getNamesRef();
                    secondaryLabel = names3 != null && names3.length > 0 ? ViewUtils.concateAliases(names3) : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = at.getOid();
                }
            } else if (element instanceof ObjectClassImpl) {
                ObjectClassImpl oc = (ObjectClassImpl)((Object)element);
                if (secondaryLabelValue == 0) {
                    String[] names4 = oc.getNamesRef();
                    secondaryLabel = names4 != null && names4.length > 0 ? names4[0] : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    String[] names5 = oc.getNamesRef();
                    secondaryLabel = names5 != null && names5.length > 0 ? ViewUtils.concateAliases(names5) : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = oc.getOid();
                }
            }
            if (secondaryLabelAbbreviate && secondaryLabelAbbreviateMaxLength < secondaryLabel.length()) {
                secondaryLabel = secondaryLabel.substring(0, secondaryLabelAbbreviateMaxLength) + "...";
            }
            label = label + "  [" + secondaryLabel + "]";
        }
        if (schemaLabelDisplay && element instanceof SchemaObject) {
            SchemaObject object = (SchemaObject)element;
            label = label + " from schema \"" + object.getSchema() + "\"";
        }
        return label;
    }

    public Image getImage(Object element) {
        if (element instanceof AttributeTypeImpl) {
            return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
        }
        if (element instanceof ObjectClassImpl) {
            return Activator.getDefault().getImage("resources/icons/object_class.gif");
        }
        return null;
    }
}

